/**
 * @file EdgesPercept.h
 * 
 * Declaration of class EdgesPercept
 * @author Dirk Thomas
 */ 

#ifndef __EdgesPercept_h_
#define __EdgesPercept_h_


#include "Tools/Streams/InOut.h"
#include "Tools/Math/Vector2.h"

/**
* The class represents a percepted edge on the field.
*/
class EdgesPercept
{
  public:
    enum {maxNumberOfEdges = 50}; /**< Specifies the maximum number of edges. */

    struct Edge
    {
      Vector2<int> point1;
      Vector2<int> point2;
    };

    Edge edges[maxNumberOfEdges]; /**< The edges. */
    int numberOfEdges; /**< The number of edges. */
    unsigned long frameNumber; /**< The frame number when perceived. */

    /**
     * Constructor.
     */
    EdgesPercept() {reset(0);}

    /**
     * The function empties the edge percept.
     */
    void reset(unsigned long frameNumber);

    /**
     * The function adds a new edge to the edge percept.
     * @param point1 The point on one end of the edge.
     * @param point2 The point on the other end of the edge.
     */
    void add(const Vector2<int>& point1, const Vector2<int>& point2);
};

/**
 * Streaming operator that reads a EdgesPercept from a stream.
 * @param stream The stream from which is read.
 * @param EdgesPercept The EdgesPercept object.
 * @return The stream.
 */ 
In& operator>>(In& stream,EdgesPercept& EdgesPercept);
 
/**
 * Streaming operator that writes a EdgesPercept to a stream.
 * @param stream The stream to write on.
 * @param EdgesPercept The EdgesPercept object.
 * @return The stream.
 */ 
Out& operator<<(Out& stream, const EdgesPercept& EdgesPercept);


#endif //__EdgesPercept_h_

/*
 * Change log :
 * 
 * $Log: EdgesPercept.h,v $
 * Revision 1.1  2004/06/15 12:11:35  thomas
 * added missing files for edges-percept
 *
 *
 */
