/**
 * @file EdgesPercept.cpp
 *
 * Implementation of class EdgesPercept.
 * @author Dirk Thomas
 */

#include "EdgesPercept.h"

void EdgesPercept::reset(unsigned long frameNumber)
{
  this->frameNumber = frameNumber;
  this->numberOfEdges = 0;
}

void EdgesPercept::add(const Vector2<int>& point1, const Vector2<int>& point2)
{
  if(numberOfEdges < maxNumberOfEdges)
  {
    edges[numberOfEdges].point1 = point1;
    edges[numberOfEdges++].point2 = point2;
    /*Edge edge;
    edge.point1 = point1;
    edge.point2 = point2;
    edges[numberOfEdges++] = edge;*/
  }
}

In& operator>>(In& stream,EdgesPercept& edgesPercept)
{
  stream >> edgesPercept.frameNumber;
  stream >> edgesPercept.numberOfEdges;
  for(int i = 0; i < edgesPercept.numberOfEdges; i++)
    stream >> edgesPercept.edges[i].point1.x >> edgesPercept.edges[i].point1.y >> edgesPercept.edges[i].point2.x >> edgesPercept.edges[i].point2.y;
  return stream;
}
 
Out& operator<<(Out& stream, const EdgesPercept& edgesPercept)
{
  stream << edgesPercept.frameNumber;
  stream << edgesPercept.numberOfEdges;
  for(int i = 0; i < edgesPercept.numberOfEdges; i++)
    stream << edgesPercept.edges[i].point1.x << edgesPercept.edges[i].point1.y << edgesPercept.edges[i].point2.x << edgesPercept.edges[i].point2.y;
  return stream;
}

/*
 * Change log :
 * 
 * $Log: EdgesPercept.cpp,v $
 * Revision 1.1  2004/06/15 12:11:35  thomas
 * added missing files for edges-percept
 *
 * 
 */
