/**
* @file ColorClassImage.cpp
*
* Implementation of class ColorClassImage
*
* @author Martin Ltzsch
*/

#include "ColorClassImage.h"
#include <string.h>


ColorClassImage::ColorClassImage() : height(144), width(176)
{
  memset(image,0,sizeof(image));
}

void ColorClassImage::convertToImage(Image& image)
{
  image.cameraInfo.resolutionHeight = height;
  image.cameraInfo.resolutionWidth = width;

  colorClass color;
  for (register int y = 0; y < height; y++) 
  {
    for (register int x = 0; x < width; x++) 
    {
      color = (colorClass)this->image[y][x];

      image.image[y][3][x] = 128;
      image.image[y][4][x] = 128;
      image.image[y][5][x] = 128;
      switch (color)
      {
      case white:
        image.image[y][0][x] = 255;
        image.image[y][1][x] = 127;
        image.image[y][2][x] = 127;
        break;
      case green:
        image.image[y][0][x] = 180;
        image.image[y][1][x] =   0;
        image.image[y][2][x] =   0;
        break;
      case gray:
        image.image[y][0][x] = 127;
        image.image[y][1][x] = 127;
        image.image[y][2][x] = 127;
        break;
      case red:
        image.image[y][0][x] = 0;
        image.image[y][1][x] = 255;
        image.image[y][2][x] = 0;
        break;
      case orange:
        image.image[y][0][x] = 100;
        image.image[y][1][x] = 255;
        image.image[y][2][x] = 0;
        break;
      case yellow:
        image.image[y][0][x] = 255;
        image.image[y][1][x] = 255;
        image.image[y][2][x] =   0;
        break;
      case yellowOrange:
        image.image[y][0][x] = 170;
        image.image[y][1][x] = 255;
        image.image[y][2][x] = 0;
        break;
      case pink:
        image.image[y][0][x] = 255;
        image.image[y][1][x] = 255;
        image.image[y][2][x] = 255;
        break;
      case skyblue:
        image.image[y][0][x] = 180;
        image.image[y][1][x] =   0;
        image.image[y][2][x] = 255;
        break;
      case blue:
        image.image[y][0][x] =  60;
        image.image[y][1][x] =  80;
        image.image[y][2][x] = 255;
        break;
      case black:
        image.image[y][0][x] =   0;
        image.image[y][1][x] = 127;
        image.image[y][2][x] = 127;
        break;
      default:
        image.image[y][0][x] = 70;
        image.image[y][1][x] = 127;
        image.image[y][2][x] = 127;
        break;
      }//switch (color)
    }
  }
}

Out& operator << (Out& stream, const ColorClassImage& colorClassImage)
{
  stream << colorClassImage.height << colorClassImage.width;

  // the current color class in the color table
  unsigned char currentColorClass = (unsigned char)colorClassImage.image[0][0];

  // the number of bytes in one sequence that have the same color class
  int currentLength = 0;

  for(int y = 0; y < colorClassImage.height; ++y)
    for(int x = 0; x < colorClassImage.width; ++x)
    {
      unsigned char nextColorClass = (unsigned char) colorClassImage.image[y][x];
    
      if (nextColorClass != currentColorClass)
      {
        stream << currentLength << currentColorClass;
        currentColorClass = nextColorClass;
        currentLength = 1;
      }
      else
        ++currentLength;
    }
  return stream << currentLength << currentColorClass;
}

In& operator>>(In& stream,ColorClassImage& colorClassImage)
{
  // the current color class in the color table
  unsigned char currentColorClass;

  // the number of bytes in one sequence that have the same color class
  unsigned int currentLength = 0;

  stream >> colorClassImage.height >> colorClassImage.width;

  for(int y = 0; y < colorClassImage.height; ++y)
    for(int x = 0; x < colorClassImage.width; ++x)
    {
      if(!currentLength)
        stream >> currentLength >> currentColorClass;
      colorClassImage.image[y][x] = currentColorClass;
      --currentLength;
    }
  return stream;
}


/*
* $Log: ColorClassImage.cpp,v $
* Revision 1.1.1.1  2004/05/22 17:25:44  cvsadm
* created new repository GT2004_WM
*
* Revision 1.6  2004/04/07 13:00:44  risler
* ddd checkin after go04 - second part
*
* Revision 1.2  2004/04/06 13:19:34  risler
* cleaned up and improved high resolution image support
*
* Revision 1.1.1.1  2004/03/29 08:28:45  Administrator
* initial transfer from tamara
*
* Revision 1.5  2004/03/16 11:31:22  nistico
* Fixed visualization of blue, black and noColor in color classified images
*
* Revision 1.4  2003/12/30 23:55:01  roefer
* Image size is now 208 x 160. Smaller images are placed in the upper left corner
*
* Revision 1.3  2003/12/15 11:46:13  juengel
* Introduced CameraInfo
*
* Revision 1.2  2003/11/03 20:22:01  juengel
* RLE streaming operator
*
* Revision 1.1  2003/10/07 10:09:36  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.2  2003/07/21 13:42:54  juengel
* Added convertToImage
*
* Revision 1.1.1.1  2003/07/02 09:40:22  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.5  2003/05/05 11:55:59  dueffert
* spelling corrected
*
* Revision 1.4  2003/03/06 11:08:05  dueffert
* re-order warning removed
*
* Revision 1.3  2003/01/09 14:11:05  jhoffman
* added some stuff needed for ISL
*
* Revision 1.2  2002/09/20 23:28:34  juengel
* Moved instance of DebugDrawingManager to RobotControlMainFrame.
*
* Revision 1.1  2002/09/10 15:26:40  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed Challenge Code
* - Removed processing of incoming audio data
* - Renamed AcousticMessage to SoundRequest
*/
