/**
* @file CollisionPercept.h
* 
* Declaration of class CollisionPercept
*
* @author <a href="mailto:goehring@informatik.hu-berlin.de">Daniel Goehring</a>
*/ 

#ifndef __CollisionPercept_h_
#define __CollisionPercept_h_

#include "Tools/Streams/InOut.h"
#include "Representations/Motion/JointData.h"


/**
* Contains detected collisions for each joint.
*/
class CollisionPercept
{
public:
  /** Constructor */ 
  CollisionPercept();

  /** Reset all states */ 
  void reset();

  /** Destructor */ 
  ~CollisionPercept();

	double state[JointData::numOfJoint];
    
  /** Did collision occur at front left leg */
  bool getCollisionFrontLeft() const;

  /** Did collision occur at front right leg */
  bool getCollisionFrontRight() const;

  /** Did collision occur at hind left leg */
  bool getCollisionHindLeft() const;

  /** Did collision occur at hind left leg */
  bool getCollisionHindRight() const;

  /** Did collision occur at head */
  bool getCollisionHead() const;

  /** Did collision occur at any body part */
  bool getCollisionAggregate() const;

  /** the last perceived frame */
  unsigned long frameNumber;

  /** sets frame number */
  void setFrameNumber(unsigned long frameNumber) {this->frameNumber = frameNumber;}

};
/**
 * Streaming operator that reads a joint state from a stream.
 * @param stream The stream from which is read.
 * @param CollisionPercept The CollisionPercept.
 * @return The stream.
 */ 
In& operator>>(In& stream, CollisionPercept& CollisionPercept);
 
/**
 * Streaming operator that writes a joint state to a stream.
 * @param stream The stream to write on.
 * @param CollisionPercept The CollisionPercept object.
 * @return The stream.
 */ 
Out& operator<<(Out& stream, const CollisionPercept& CollisionPercept);

#endif //__CollisionPercept_h_

/*
* Change log :
* 
* $Log: CollisionPercept.h,v $
* Revision 1.2  2004/06/23 11:02:26  goehring
* Xabsl symbol collision-side added
*
* Revision 1.1.1.1  2004/05/22 17:25:44  cvsadm
* created new repository GT2004_WM
*
* Revision 1.3  2004/01/19 14:53:46  dueffert
* all frameNumbers (and not only some of them) are unsigned long now
*
* Revision 1.2  2003/11/14 19:02:25  goehring
* frameNumber added
*
* Revision 1.1  2003/10/07 10:09:36  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1  2003/09/26 21:23:20  loetzsch
* renamed class JointState to CollisionPercept
*
* Revision 1.2  2003/09/26 15:27:27  juengel
* Renamed DataTypes to representations.
*
* Revision 1.1.1.1  2003/07/02 09:40:22  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.4  2003/06/10 15:06:06  goehring
* Xabsl symbol functions added
*
* Revision 1.3  2003/06/09 12:32:34  goehring
* Added reset function
*
* Revision 1.2  2003/06/02 11:29:16  goehring
* Review
*
* Revision 1.1  2003/04/25 19:49:28  goehring
* Added CollisionPercept
*
*/
