/**
* @file CollisionPercept.cpp
*
* Implementation of class CollisionPercept.
*/

#include "CollisionPercept.h"

CollisionPercept::CollisionPercept()
{
  for (int i = 0; i < JointData::numOfJoint; i++)
  {
    state[i] = 0;
  }
}

void CollisionPercept::reset()
{
  for (int i = 0; i < JointData::numOfJoint; i++)
  {
    state[i] = 0;
  }
}


CollisionPercept::~CollisionPercept()
{ }


/** Did collision occur at front left leg */
  bool CollisionPercept::getCollisionFrontLeft() const
  {
    return ((state[JointData::legFL1] >= 1000) ||
            (state[JointData::legFL2] >= 1000) ||
            (state[JointData::legFL3] >= 1000));
  }

  /** Did collision occur at front right leg */
  bool CollisionPercept::getCollisionFrontRight() const
  {
    return ((state[JointData::legFR1] >= 1000) ||
            (state[JointData::legFR2] >= 1000) ||
            (state[JointData::legFR3] >= 1000));
  
  }
  /** Did collision occur at hind left leg */
  bool CollisionPercept::getCollisionHindLeft() const
  {
    return ((state[JointData::legHL1] >= 1000) ||
            (state[JointData::legHL2] >= 1000) ||
            (state[JointData::legHL3] >= 1000));
  }


  /** Did collision occur at hind right leg */
  bool CollisionPercept::getCollisionHindRight() const
  {
    return ((state[JointData::legHR1] >= 1000) ||
            (state[JointData::legHR2] >= 1000) ||
            (state[JointData::legHR3] >= 1000));

  }


  /** Did collision occur at head */
  bool CollisionPercept::getCollisionHead() const
  {
    return ((state[JointData::neckTilt] >= 1000) ||
            (state[JointData::headPan]  >= 1000) ||
            (state[JointData::headTilt] >= 1000));
  }


  /** Did collision occur at any body part */
  bool CollisionPercept::getCollisionAggregate() const
  {
    return (getCollisionFrontLeft()||
            getCollisionFrontRight()||
            getCollisionHindLeft()||
            getCollisionHindRight());
  }


In& operator>>(In& stream, CollisionPercept& collisionPercept)
{
  stream >> collisionPercept.frameNumber;
  stream.read(&collisionPercept, sizeof(collisionPercept));
  return stream;
}

Out& operator<<(Out& stream, const CollisionPercept& collisionPercept)
{
  stream << collisionPercept.frameNumber;
  stream.write(&collisionPercept, sizeof(collisionPercept));
  return stream;
}


/*
 * Change log :
 * 
 * $Log: CollisionPercept.cpp,v $
 * Revision 1.4  2004/06/23 15:33:08  goehring
 * no head info in collisionAggregate
 *
 * Revision 1.3  2004/06/23 11:02:26  goehring
 * Xabsl symbol collision-side added
 *
 * Revision 1.2  2004/05/27 17:13:38  jhoffman
 * - renaming: tilt1 -> neckTilt,  pan -> headPan,  tilt2 -> headTilt
 * - clipping included for setJoints
 * - removed some microrad/rad-bugs
 * - bodyPosture constructor and "=" operator fixed
 *
 * Revision 1.1.1.1  2004/05/22 17:25:44  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.2  2003/11/14 19:02:25  goehring
 * frameNumber added
 *
 * Revision 1.1  2003/10/07 10:09:36  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1  2003/09/26 21:23:20  loetzsch
 * renamed class JointState to CollisionPercept
 *
 * Revision 1.1.1.1  2003/07/02 09:40:22  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.5  2003/06/21 13:06:51  goehring
 * Debug Collisionsymbols
 *
 * Revision 1.4  2003/06/10 15:06:06  goehring
 * Xabsl symbol functions added
 *
 * Revision 1.3  2003/06/09 12:32:34  goehring
 * Added reset function
 *
 * Revision 1.2  2003/06/02 11:29:16  goehring
 * Review
 *
 * Revision 1.1  2003/04/25 19:49:28  goehring
 * Added CollisionPercept
 *
 */

