/**
 * @file CameraMatrix.h
 * 
 * Declaration of class CameraMatrix
 */ 

#ifndef __CameraMatrix_h_
#define __CameraMatrix_h_

#include "Tools/Math/Pose3D.h"
#include "Tools/Streams/InOut.h"

/**
* Matrix describing transformation from neck joint to camera.
*/
class CameraMatrix: public Pose3D
{
  public:
    unsigned long frameNumber; /**< The frame number when perceived. */
    
    CameraMatrix(const Pose3D pose): Pose3D(pose),isValid(true),frameNumber(0) {}
    CameraMatrix():isValid(true),frameNumber(0) {}

    void setFrameNumber(unsigned long frameNumber) {this->frameNumber = frameNumber;}

    bool isValid; /**< Matrix is only valid if motion was stable. */
    


};

/**
 * Streaming operator that reads a CameraMatrix from a stream.
 * @param stream The stream from which is read.
 * @param cameraMatrix The CameraMatrix object.
 * @return The stream.
 */ 
In& operator>>(In& stream,CameraMatrix& cameraMatrix);
 
/**
 * Streaming operator that writes a CameraMatrix to a stream.
 * @param stream The stream to write on.
 * @param cameraMatrix The CameraMatrix object.
 * @return The stream.
 */ 
Out& operator<<(Out& stream, const CameraMatrix& cameraMatrix);

#endif //__CameraMatrix_h_

/*
 * Change log :
 * 
 * $Log: CameraMatrix.h,v $
 * Revision 1.1.1.1  2004/05/22 17:25:44  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.3  2004/01/19 14:53:46  dueffert
 * all frameNumbers (and not only some of them) are unsigned long now
 *
 * Revision 1.2  2003/11/14 19:02:25  goehring
 * frameNumber added
 *
 * Revision 1.1  2003/10/07 10:09:36  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.2  2003/09/25 11:23:52  juengel
 * Removed BlobCollection.
 *
 * Revision 1.1.1.1  2003/07/02 09:40:22  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.5  2003/04/01 16:51:09  roefer
 * CameraMatrix contains validity and is calculated in Geometry
 *
 * Revision 1.4  2003/01/11 21:30:35  roefer
 * Removed the stuff added, because it is not required,
 * and it is incompatible with existing log files
 *
 * Revision 1.3  2003/01/09 14:12:28  jhoffman
 * added some stuff needed for ISL
 *
 * Revision 1.2  2002/09/22 18:40:49  risler
 * added new math functions, removed GTMath library
 *
 * Revision 1.1  2002/09/10 15:26:40  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed Challenge Code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.4  2002/08/31 16:19:46  risler
 * doxygen comments corrected
 *
 * Revision 1.3  2002/08/22 14:41:03  risler
 * added some doxygen comments
 *
 * Revision 1.2  2002/07/23 13:32:57  loetzsch
 * new streaming classes
 *
 * removed many #include statements
 *
 * Revision 1.1.1.1  2002/05/10 12:40:13  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.6  2002/04/02 13:10:18  dueffert
 * big change: odometryData and cameraMatrix in image now, old logfiles may be obsolete
 *
 * Revision 1.5  2002/01/18 12:24:42  mkunz
 * camera matrix changed
 *
 * Revision 1.4  2001/12/10 17:47:05  risler
 * change log added
 *
 */
