/**
 * @file CameraMatrix.cpp
 *
 * Implementation of class CameraMatrix.
 */

#include "CameraMatrix.h"

In& operator>>(In& stream,CameraMatrix& cameraMatrix)
{
  // This is a hack to read the validity of the matrix without changing the format
  stream.read(&(Pose3D&)cameraMatrix,sizeof(Pose3D));
  cameraMatrix.isValid = cameraMatrix.translation.z >= 0;
  if(!cameraMatrix.isValid)
    cameraMatrix.translation.z = -cameraMatrix.translation.z;
//  stream >> cameraMatrix.frameNumber;
  cameraMatrix.frameNumber = 0;
  return stream;
}
 
Out& operator<<(Out& stream, const CameraMatrix& cameraMatrix)
{
  // This is a hack to store the validity of the matrix without changing the format
  Pose3D pose = cameraMatrix;
  if(!cameraMatrix.isValid)
    pose.translation.z = -pose.translation.z;
  stream.write(&pose,sizeof(Pose3D));
//  stream << cameraMatrix.frameNumber;
  return stream;
}

/*
 * Change log :
 * 
 * $Log: CameraMatrix.cpp,v $
 * Revision 1.1.1.1  2004/05/22 17:25:44  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.2  2003/11/14 19:02:25  goehring
 * frameNumber added
 *
 * Revision 1.1  2003/10/07 10:09:36  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:22  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.2  2003/04/01 16:51:09  roefer
 * CameraMatrix contains validity and is calculated in Geometry
 *
 * Revision 1.1  2002/09/10 15:26:40  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed Challenge Code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.1.1.1  2002/05/10 12:40:13  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.5  2002/04/02 13:10:18  dueffert
 * big change: odometryData and cameraMatrix in image now, old logfiles may be obsolete
 *
 * Revision 1.4  2002/01/18 12:24:42  mkunz
 * camera matrix changed
 *
 * Revision 1.3  2001/12/10 17:47:05  risler
 * change log added
 *
 */
