/**
 * @file BodyPosture.h
 * 
 * Declaration of class BodyPosture
 */ 

#ifndef __BodyPosture_h_
#define __BodyPosture_h_


#include "Tools/Streams/InOut.h"

/**
 * The class represents the robots body percept
 *
 * The percept consists of current switches and a variable containing
 * whether the robot stands or is crashed. */
class BodyPosture
{
public:
  BodyPosture();
  ~BodyPosture();

  /** copies another BodyPosture to this one */
  void operator = (const BodyPosture& other);

  unsigned long frameNumber;

  double neckHeightCalculatedFromLegSensors;
  double bodyRollCalculatedFromLegSensors;
  double bodyTiltCalculatedFromLegSensors;

  double neckHeightProvidedByMotionControl;
  double bodyRollProvidedByMotionControl;
  double bodyTiltProvidedByMotionControl;

  double bodyRollCalculatedFromAccelerationSensors;
  double bodyTiltCalculatedFromAccelerationSensors;
};

/**
 * Streaming operator that reads a BodyPosture from a stream.
 * @param stream The stream from which is read.
 * @param bodyPosture The BodyPosture object.
 * @return The stream.
 */ 
In& operator>>(In& stream,BodyPosture& bodyPosture);
 
/**
 * Streaming operator that writes a BodyPosture to a stream.
 * @param stream The stream to write on.
 * @param bodyPosture The BodyPosture object.
 * @return The stream.
 */ 
Out& operator<<(Out& stream, const BodyPosture& bodyPosture);


#endif //__BodyPosture_h_

/*
 * Change log :
 * 
 * $Log: BodyPosture.h,v $
 * Revision 1.3  2004/05/26 17:11:40  juengel
 * Added frameNumber.
 *
 * Revision 1.2  2004/05/26 15:47:07  dueffert
 * private members only and no functions to access anything are not useful
 *
 * Revision 1.1  2004/05/26 15:18:58  juengel
 * Added BodyPosture.
 *
 */
