/**
 * @file BodyPosture.cpp
 *
 * Implementation of class BodyPosture.
 */

#include "BodyPosture.h"

BodyPosture::BodyPosture():
frameNumber(0),
neckHeightCalculatedFromLegSensors(0),
bodyRollCalculatedFromLegSensors(0),
bodyTiltCalculatedFromLegSensors(0),
neckHeightProvidedByMotionControl(0),
bodyRollProvidedByMotionControl(0),
bodyTiltProvidedByMotionControl(0),
bodyRollCalculatedFromAccelerationSensors(0),
bodyTiltCalculatedFromAccelerationSensors(0)
{
}

BodyPosture::~BodyPosture()
{
}

void BodyPosture::operator = (const BodyPosture& other)
{
  frameNumber = other.frameNumber;
  neckHeightCalculatedFromLegSensors = other.neckHeightCalculatedFromLegSensors;
  bodyRollCalculatedFromLegSensors = other.bodyRollCalculatedFromLegSensors;
  bodyTiltCalculatedFromLegSensors = other.bodyTiltCalculatedFromLegSensors;

  neckHeightProvidedByMotionControl = other.neckHeightProvidedByMotionControl;
  bodyRollProvidedByMotionControl = other.bodyRollProvidedByMotionControl;
  bodyTiltProvidedByMotionControl = other.bodyTiltProvidedByMotionControl;

  bodyRollCalculatedFromAccelerationSensors = other.bodyRollCalculatedFromAccelerationSensors;
  bodyTiltCalculatedFromAccelerationSensors = other.bodyTiltCalculatedFromAccelerationSensors;
}

In& operator>>(In& stream,BodyPosture& BodyPosture)
{
  stream.read(&BodyPosture,sizeof(BodyPosture));
  return stream;
}
 
Out& operator<<(Out& stream, const BodyPosture& BodyPosture)
{
  stream.write(&BodyPosture,sizeof(BodyPosture));
  return stream;
}


/*
 * Change log :
 * 
 * $Log: BodyPosture.cpp,v $
 * Revision 1.4  2004/05/27 17:13:37  jhoffman
 * - renaming: tilt1 -> neckTilt,  pan -> headPan,  tilt2 -> headTilt
 * - clipping included for setJoints
 * - removed some microrad/rad-bugs
 * - bodyPosture constructor and "=" operator fixed
 *
 * Revision 1.3  2004/05/27 09:54:52  juengel
 * Fixed bug in operator=.
 *
 * Revision 1.2  2004/05/26 21:19:17  juengel
 * Added frameNumber to = operator.
 *
 * Revision 1.1  2004/05/26 15:18:58  juengel
 * Added BodyPosture.
 *
 */
