/** 
* @file PIDData.h
*
* Definition of PIDData.
* This defines PID values for all joints.
*
* @author Max Risler
*/
#ifndef __PIDDATA_H__
#define __PIDDATA_H__

#include "JointData.h"
#include "Tools/Streams/InOut.h"

/**
* PID data set. Containing servo gain values for all used joints.
* @author Max Risler
*/
class PIDData
{
public:

  /** The pid servo gain values */
  int p[JointData::numOfJoint];
  int i[JointData::numOfJoint];
  int d[JointData::numOfJoint];

  /** Default constructor */
  PIDData();

  /** Assignment operator */
  PIDData& operator=(const PIDData& other);

  /** Copy constructor */
  PIDData(const PIDData& other);

  /** 
  * set the values for one joint
  */
  void setValues(JointData::JointID joint, int ap, int ai, int ad);

  /**
  *
  */
  void setToDefaults();
  
  /** 
  * set the values for two leg joints
  */
  void setLegFJ1Values(int ap, int ai, int ad);
  void setLegHJ1Values(int ap, int ai, int ad);
  void setLegFJ2Values(int ap, int ai, int ad);
  void setLegHJ2Values(int ap, int ai, int ad);
  void setLegFJ3Values(int ap, int ai, int ad);
  void setLegHJ3Values(int ap, int ai, int ad);
};


/**
 * Streaming operator that reads PIDData from a stream.
 * @param stream The stream from which is read.
 * @param pidData The PIDData object.
 * @return The stream.
 */ 
In& operator>>(In& stream,PIDData& pidData);
 
/**
 * Streaming operator that writes PIDData to a stream.
 * @param stream The stream to write on.
 * @param pidData The PIDData object.
 * @return The stream.
 */ 
Out& operator<<(Out& stream, const PIDData& pidData);

#endif //__PIDDATA_H__

/*
 * Change log :
 * 
 * $Log: PIDData.h,v $
 * Revision 1.1.1.1  2004/05/22 17:25:30  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.2  2003/10/29 13:20:13  juengel
 * added method "setToDefaults"
 *
 * Revision 1.1  2003/10/07 10:07:01  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:22  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.2  2003/05/16 17:02:17  roefer
 * JAM removed
 *
 * Revision 1.1  2002/11/19 17:13:05  risler
 * added datatype PIDData
 * support for sending new pid values at runtime
 *
 */
