/**
 * @file OdometryData.cpp
 *
 * Implementation of the OdometryData class
 *
 * @author Max Risler
 */ 

#include "Tools/Streams/InOut.h"
#include "OdometryData.h"

OdometryData::OdometryData()
{
}

OdometryData::~OdometryData()
{
}

In& operator>>(In& stream,OdometryData& odometryData)
{
  stream.read(&odometryData,sizeof(OdometryData));
  return stream;
}
 
Out& operator<<(Out& stream, const OdometryData& odometryData)
{
  stream.write(&odometryData,sizeof(OdometryData));
  return stream;
}


/*
 * Change log :
 * 
 * $Log: OdometryData.cpp,v $
 * Revision 1.1.1.1  2004/05/22 17:25:30  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.1  2003/10/07 10:07:01  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:22  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.2  2002/11/19 15:43:03  dueffert
 * doxygen comments corrected
 *
 * Revision 1.1  2002/09/10 15:26:40  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed Challenge Code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.2  2002/08/30 13:33:05  dueffert
 * removed unused includes
 *
 * Revision 1.1.1.1  2002/05/10 12:40:13  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.6  2002/04/02 13:10:18  dueffert
 * big change: odometryData and cameraMatrix in image now, old logfiles may be obsolete
 *
 * Revision 1.5  2002/03/19 18:37:18  risler
 * added neckHeight, stableMotion
 *
 * Revision 1.4  2001/12/13 14:14:39  risler
 * OdometryData derived from Pose2D
 *
 * Revision 1.3  2001/12/10 17:47:06  risler
 * change log added
 *
 */
