/**
* @file MotionRequest.cpp
*
* Implementation of class MotionRequest
* 
* @author Martin Ltzsch
* @author Max Risler
*/

#include "MotionRequest.h"
#include <stdio.h>
#include <string.h>

void MotionRequest::printOut(char* destination) const
{
  sprintf(destination,"%s",getMotionName());

  switch (motionType)
  {
  case walk:
    sprintf(destination,"%s : %s,%.1f %.1f %.1f",
      getMotionName(),
      getWalkTypeName(),
      walkRequest.walkParams.translation.x,walkRequest.walkParams.translation.y,walkRequest.walkParams.rotation);
    break;
  case specialAction:
    sprintf(destination,"%s : %s",
      getMotionName(),
      getSpecialActionName());
    break;
  default:
    sprintf(destination,"%s", getMotionName());
    break;
  }
}

void MotionRequest::operator = (const MotionRequest& other)
{
  memcpy(this,&other,sizeof(MotionRequest));
}

SpecialActionRequest::SpecialActionID SpecialActionRequest::getSpecialActionIDFromName(const char* name)
{
  for (int i=0;i<SpecialActionRequest::numOfSpecialAction;i++)
  {
    if (strcmp(name, (SpecialActionRequest::getSpecialActionIDName((SpecialActionRequest::SpecialActionID)i)))==0)
    {
      return (SpecialActionRequest::SpecialActionID)i;
    }
  }

  return SpecialActionRequest::numOfSpecialAction;   
}


In& operator>>(In& stream,MotionRequest& motionRequest)
{
  stream.read(&motionRequest,sizeof(MotionRequest));
  return stream;
}
 
Out& operator<<(Out& stream, const MotionRequest& motionRequest)
{
  stream.write(&motionRequest,sizeof(MotionRequest));
  return stream;
}


/*
 * Change log :
 * 
 * $Log: MotionRequest.cpp,v $
 * Revision 1.2  2004/06/02 17:19:19  spranger
 * split up motionrequest in tail-,specialaction-,walk-request
 * removed walkcycle double (its in motioninfo)
 *
 * Revision 1.1.1.1  2004/05/22 17:25:18  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.2  2003/12/16 18:52:55  loetzsch
 * added a function for retrieving the id for as string.
 *
 * Revision 1.1  2003/10/07 10:07:01  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:22  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.2  2002/09/22 18:40:54  risler
 * added new math functions, removed GTMath library
 *
 * Revision 1.1  2002/09/10 15:26:40  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed Challenge Code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.3  2002/08/29 14:03:12  dueffert
 * includes in correct case, system includes in <>
 *
 * Revision 1.2  2002/07/08 13:55:54  dueffert
 * gcc warning removed
 *
 * Revision 1.1.1.1  2002/05/10 12:40:13  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.9  2002/05/04 18:18:13  risler
 * made printOut const
 *
 * Revision 1.8  2002/05/04 12:43:38  loetzsch
 * The currently executed MotionRequest is now sent from the MotionControl
 * to the BehaviorControl via the OdometryData structure
 *
 * Revision 1.7  2002/04/23 15:08:45  risler
 * changed MotionRequest: walk instead of normalWalk,... and walkType added
 *
 * Revision 1.6  2002/04/16 16:20:14  dueffert
 * no message
 *
 * Revision 1.5  2002/04/15 13:39:24  rentmeister
 * DoWalkingEngine (Dortmunder WalkingEngine)
 *
 * Revision 1.4  2002/04/08 16:27:26  mierswa
 * New input for FuzzyBeahviourControl.
 *
 * Revision 1.3  2002/04/02 16:06:27  loetzsch
 * added printOut function
 *
 * Revision 1.2  2001/12/10 17:47:06  risler
 * change log added
 *
 */
