/** 
* @file MotionInfo.h
*
* Definition of class MotionInfo.
*
* @author Martin Ltzsch
*/

#ifndef __MotionInfo_h__
#define __MotionInfo_h__

#include "MotionRequest.h"


/**
* @class MotionInfo
*
* Contains information about the motions which are executed by the Motion process.
*
* @author Martin Ltzsch
*/
class MotionInfo 
{
public:
  /** Constructor */
  MotionInfo();

  /** The motion request which is executed by the MotionControl module */
  MotionRequest executedMotionRequest;
 
  /** If true, the motion is stable, leading to a valid camera matrix */
  bool motionIsStable;

  /** The height of the neck joint in mm as estimated by the motion modules */
  double neckHeight;

  /** The tilt of the body in rad */
  double bodyTilt;

  /** 
  * The position inside the step of the walking engine
  * slides from 0 to 1 during one step
  */
  double positionInWalkCycle;
  
};

/**
* Streaming operator that reads a MotionInfo from a stream.
* @param stream The stream from which is read.
* @param executedMotionInfo The MotionInfo object.
* @return The stream.
*/ 
In& operator>>(In& stream,MotionInfo& executedMotionInfo);

/**
* Streaming operator that writes a MotionInfo to a stream.
* @param stream The stream to write on.
* @param executedMotionInfo The MotionInfo object.
* @return The stream.
*/ 
Out& operator<<(Out& stream, const MotionInfo& executedMotionInfo);

#endif // __MotionInfo_h__

/*
 * Change log :
 * 
 * $Log: MotionInfo.h,v $
 * Revision 1.2  2004/05/26 15:46:19  dueffert
 * typo fixed
 *
 * Revision 1.1  2004/05/26 15:17:15  loetzsch
 * added class MotionInfo
 *
 */
