/**
* @file MotionInfo.cpp
*
* Implementation of class MotionInfo
* 
* @author Martin Ltzsch
* @author Max Risler
*/

#include "MotionInfo.h"

MotionInfo::MotionInfo()
:positionInWalkCycle(0) , bodyTilt(0), neckHeight(100), motionIsStable(true)
{
}

In& operator>>(In& stream,MotionInfo& motionInfo)
{
  stream.read(&motionInfo,sizeof(MotionInfo));
  return stream;
}
 
Out& operator<<(Out& stream, const MotionInfo& motionInfo)
{
  stream.write(&motionInfo,sizeof(MotionInfo));
  return stream;
}


/*
 * Change log :
 * 
 * $Log: MotionInfo.cpp,v $
 * Revision 1.2  2004/05/26 17:54:07  juengel
 * Bug fixed.
 *
 * Revision 1.1  2004/05/26 15:17:15  loetzsch
 * added class MotionInfo
 *
 */
