/**
 * @file LEDValue.h
 *
 * Definition of LEDValue.
 * Description of LED value data.
 *
 * @author Max Risler
 */

#ifndef __LEDValue_h_
#define __LEDValue_h_

#include "Tools/Streams/InOut.h"
#include "Representations/Motion/JointDataBuffer.h"

/**
* Description of LED value data.
*/
class LEDValue
{
public:
  /**
   * enum describing indexes of LEDs 
   */
  enum LED {
    redLB,
    greenL,
    redLT,
    redRB,
    greenR,
    redRT,
    greenT, 
    tailBlue,
    tailRed,
    numOfLED_ERS210,
    headOrange = 0,
    headWhite,
    modeRed,
    modeGreen,
    modeBlue,
    wireless,
    face1,
    face2,
    face3,
    face4,
    face5,
    face6,
    face7,
    face8,
    face9,
    face10,
    face11,
    face12,
    face13,
    face14,
    backFrontBlue,
    backFrontWhite,
    backMiddleOrange,
    backMiddleWhite,
    backRearRed,
    backRearWhite,
    numOfLED_ERS7
  };

  /** the LED data buffer */
  long data[jointDataBufferNumOfFrames];

  LEDValue();
};

/**
 * Streaming operator that reads a LEDValue from a stream.
 * @param stream The stream from which is read.
 * @param ledValue The LEDValue object.
 * @return The stream.
 */ 
In& operator>>(In& stream,LEDValue& ledValue);
 
/**
 * Streaming operator that writes a LEDValue to a stream.
 * @param stream The stream to write on.
 * @param ledValue The LEDValue object.
 * @return The stream.
 */ 
Out& operator<<(Out& stream, const LEDValue& ledValue);


#endif //__LEDValue_h_

/*
 * Change log :
 * 
 * $Log: LEDValue.h,v $
 * Revision 1.1.1.1  2004/05/22 17:25:18  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.3  2003/12/31 14:29:20  roefer
 * Joints and LEDs for ERS-7
 *
 * Revision 1.2  2003/10/14 07:30:33  roefer
 * Added type name for LED enum
 *
 * Revision 1.1  2003/10/07 10:07:01  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.2  2003/09/26 15:27:27  juengel
 * Renamed DataTypes to representations.
 *
 * Revision 1.1.1.1  2003/07/02 09:40:22  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.2  2003/02/25 11:43:45  dueffert
 * line feed and doxygen bugs fixed
 *
 * Revision 1.1  2002/09/10 15:26:40  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed Challenge Code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.4  2002/08/27 08:55:37  risler
 * removed old todo
 *
 * Revision 1.3  2002/08/22 14:41:03  risler
 * added some doxygen comments
 *
 * Revision 1.2  2002/07/23 13:32:57  loetzsch
 * new streaming classes
 *
 * removed many #include statements
 *
 * Revision 1.1.1.1  2002/05/10 12:40:13  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.6  2002/05/07 05:49:56  dueffert
 * new LED handling implemented
 *
 * Revision 1.5  2001/12/10 17:47:05  risler
 * change log added
 *
 */
