/**
* @file LEDValue.cpp
*
* Implementation of class LEDValue
*
* @author Martin Ltzsch
* @author Max Risler
*/ 

#include "LEDValue.h"

LEDValue::LEDValue()
{
  for (int i = 0; i < jointDataBufferNumOfFrames; i++)
    data[i]=0;
}

In& operator>>(In& stream,LEDValue& ledValue)
{
  stream.read(&ledValue,sizeof(LEDValue));
  return stream;
}
 
Out& operator<<(Out& stream, const LEDValue& ledValue)
{
  stream.write(&ledValue,sizeof(LEDValue));
  return stream;
}


/*
 * Change log :
 * 
 * $Log: LEDValue.cpp,v $
 * Revision 1.1.1.1  2004/05/22 17:25:18  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.1  2003/10/07 10:07:01  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:22  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.1  2002/09/10 15:26:40  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed Challenge Code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.2  2002/08/26 17:13:26  dueffert
 * typo corrected
 *
 * Revision 1.1.1.1  2002/05/10 12:40:13  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.5  2002/05/07 05:49:56  dueffert
 * new LED handling implemented
 *
 * Revision 1.4  2001/12/10 17:47:05  risler
 * change log added
 *
 */
