/**
* @file LEDRequest.cpp
*
* Implementation of class LEDRequest.
*/

#include "LEDRequest.h"

LEDRequest::LEDRequest() : 
redTopLEDs(bothOff),
redBottomLEDs(bothOff),
tailMode(on),
backFrontWhiteLED(oooo),
backFrontBlueLED(oooo),
backMiddleWhiteLED(oooo),
backMiddleOrangeLED(oooo),
backRearWhiteLED(oooo),
backRearRedLED(oooo),
headOrangeLED(oooo),
headWhiteLED(oooo),
showCognitionFrameLostWarning(false)
{
  for(int i = 0; i < 14; i++) faceLED[i] = oooo;
}

In& operator>>(In& stream,LEDRequest& ledRequest)
{
  stream.read(&ledRequest,sizeof(LEDRequest));
  return stream;
}

Out& operator<<(Out& stream, const LEDRequest& ledRequest)
{
  stream.write(&ledRequest,sizeof(LEDRequest));
  return stream;
}

/*
* Change log :
* 
* $Log: LEDRequest.cpp,v $
* Revision 1.2  2004/06/15 17:48:00  juengel
* Added showCognitionFrameLostWarning.
*
* Revision 1.1.1.1  2004/05/22 17:25:18  cvsadm
* created new repository GT2004_WM
*
* Revision 1.7  2004/03/25 21:20:19  juengel
* Added head LEDs.
*
* Revision 1.6  2004/03/25 19:56:28  loetzsch
* again changed the led request
*
* Revision 1.5  2004/03/25 17:39:17  loetzsch
* renamed initial-setup-mode to back-mode
*
* Revision 1.4  2004/03/21 19:08:15  juengel
* Added back*White LED support.
*
* Revision 1.3  2004/03/20 19:24:07  juengel
* Added face LEDs to LEDRequest
*
* Revision 1.2  2004/03/01 12:37:22  wachter
* Added LED-Request for button-interface
*
* Revision 1.1  2003/10/07 10:07:01  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:22  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.3  2003/05/08 14:27:33  risler
* added tailMode to LEDRequest
*
* Revision 1.2  2002/11/18 17:20:22  loetzsch
* removed "old version" of LED request
*
* Revision 1.1  2002/09/10 15:26:40  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed Challenge Code
* - Removed processing of incoming audio data
* - Renamed AcousticMessage to SoundRequest
*
* Revision 1.2  2002/05/16 22:36:11  roefer
* Team communication and GTMath bugs fixed
*
* Revision 1.8  2002/05/04 17:42:27  loetzsch
* extended the request by a new version
*
* Revision 1.7  2002/02/28 14:35:53  risler
* changed names in LEDRequest
*
* Revision 1.6  2002/02/07 19:57:06  risler
* DefaultLEDControl uses getPlayer now, removed team and role from LEDRequest
*
* Revision 1.5  2001/12/10 17:47:05  risler
* change log added
*
*/
