/**
* @file JointDataSequence.cpp
*
* Implementation of class JointDataSequence
*
* @author Max Risler
*/

#include "JointDataSequence.h"

JointDataSequence::JointDataSequence()
{
  numOfEntries = 0;
  loop = false;
}

JointDataSequence& JointDataSequence::operator=(const JointDataSequence& other)
{
  numOfEntries = other.numOfEntries;
  loop = other.loop;
  for (int i = 0; i < numOfEntries; i++)
  {
    entry[i] = other.entry[i];
    interpolate[i] = other.interpolate[i];
    repeats[i] = other.repeats[i];
  }
  return *this;
}

void JointDataSequence::addEntry(const JointData& jointData, bool interp, int rep)
{
  entry[numOfEntries] = jointData;
  interpolate[numOfEntries] = interp;
  repeats[numOfEntries] = rep;
  numOfEntries++;
}

In& operator>>(In& stream,JointDataSequence& jointDataSequence)
{
  int x;

  stream >> jointDataSequence.numOfEntries;
  stream >> x; jointDataSequence.loop = (x!=0);

  for (int i=0;i<jointDataSequence.numOfEntries;i++)
  {
    stream >> jointDataSequence.entry[i];
    stream >> jointDataSequence.repeats[i];
    stream >> x; jointDataSequence.interpolate[i] = (x!=0);
  }
  return stream;
}
 
Out& operator<<(Out& stream, const JointDataSequence& jointDataSequence)
{
  stream << jointDataSequence.numOfEntries;
  stream << jointDataSequence.loop;

  for (int i=0;i<jointDataSequence.numOfEntries;i++)
  {
    stream << jointDataSequence.entry[i];
    stream << jointDataSequence.repeats[i];
    stream << jointDataSequence.interpolate[i];
  }
  return stream;
}

/*
 * Change log :
 * 
 * $Log: JointDataSequence.cpp,v $
 * Revision 1.1.1.1  2004/05/22 17:25:18  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.1  2003/10/07 10:07:01  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:22  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.2  2002/11/28 16:50:43  risler
 * added addEntry
 *
 * Revision 1.1  2002/09/10 15:26:40  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed Challenge Code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.1.1.1  2002/05/10 12:40:13  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.2  2002/02/21 18:02:51  risler
 * added assignment operator
 *
 * Revision 1.1  2002/02/08 22:31:46  risler
 * added JointDataSequence, finished DebugMotionControl
 *
 */
