/** 
* @file JointDataBuffer.h
*
* Definition of JointDataBuffer class.
* The jointdata struct is a non NDA violating description of joint vector data
*
* @author Max Risler
*/
#ifndef __JOINTDATABUFFER_H__
#define __JOINTDATABUFFER_H__

#include "JointData.h"

#include "Tools/Streams/InOut.h"

/** Number of frames in the buffer.
* This number defines how many frames are computed each run, 
* and therefore how often Motion::execute will be called.
*/
static const int jointDataBufferNumOfFrames = 1;


/**
* A buffer for joint data sets, containing all frames computed in one call of Motion::execute.
* @author Max Risler
*/
struct JointDataBuffer
{
public:
  /** Constructor */
  JointDataBuffer();
  
  /** The joint data frames */
  JointData frame[jointDataBufferNumOfFrames];
};

/**
 * Streaming operator that reads a JointDataBuffer from a stream.
 * @param stream The stream from which is read.
 * @param jointDataBuffer The JointDataBuffer object.
 * @return The stream.
 */ 
In& operator>>(In& stream,JointDataBuffer& jointDataBuffer);
 
/**
 * Streaming operator that writes a JointDataBuffer to a stream.
 * @param stream The stream to write on.
 * @param jointDataBuffer The JointDataBuffer object.
 * @return The stream.
 */ 
Out& operator<<(Out& stream, const JointDataBuffer& jointDataBuffer);

#endif //__JOINTDATABUFFER_H__

/*
 * Change log :
 * 
 * $Log: JointDataBuffer.h,v $
 * Revision 1.1.1.1  2004/05/22 17:25:18  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.1  2003/10/07 10:07:01  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.2  2003/09/25 11:23:52  juengel
 * Removed BlobCollection.
 *
 * Revision 1.1.1.1  2003/07/02 09:40:22  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.2  2002/10/14 13:14:24  dueffert
 * doxygen comments corrected
 *
 * Revision 1.1  2002/09/10 15:26:40  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed Challenge Code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.2  2002/07/23 13:32:57  loetzsch
 * new streaming classes
 *
 * removed many #include statements
 *
 * Revision 1.1.1.1  2002/05/10 12:40:13  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.5  2001/12/28 09:02:23  roefer
 * jointDataBufferNumOfFrames reduced to 1
 *
 * Revision 1.4  2001/12/10 17:47:05  risler
 * change log added
 *
 */
