/**
* @file HeadControlMode.h
* 
* Based on old implementation of HeadControlMode from GT2001
*
* Declaration of class HeadControlMode
* Stores head modes requested by BehaviorControl
*
* @author Matthias Juengel
* @author Nils Koschmieder
*/ 

#ifndef __HeadControlMode_h_
#define __HeadControlMode_h_

#include "Tools/Streams/InOut.h"
#include "Tools/Math/Vector3.h"
#include "Tools/Math/Vector2.h"


/**
* Stores head modes requested by BehaviorControl
*/
class HeadControlMode
{
public:
  /** constructor */
  HeadControlMode();

  /** destructor */
  ~HeadControlMode();
  
  /** possible head control modes */
  enum HeadControlModes 
  {
	    none,
      searchForBall,
      searchAuto,
      searchForLandmarks,
      searchForLandmarksHeadLow,
      lookBetweenFeet,
      lookLeft,
      lookRight,
      lookStraightAhead,
      catchBall,
      releaseCaughtBallWhenTurningLeft,
      releaseCaughtBallWhenTurningRight,
      stayAsForced,
      lookToStars,
      lookParallelToGround,
      lookTowardOpponentGoal,

      direct,
      calibrate,
      calibrateHeadSpeed,
      watchOrigin,
      
			openChallengePullBridge,
			openChallengeTest,
			openChallengeTest2,
      openChallengeGoToBridge,
      openChallengeJoysickMode,
      openChallengeReset,

      searchForBallLeft,
      searchForBallRight,

      numOfHeadControlModes
  };
  
  /** The requested head control mode */
  HeadControlModes headControlMode;
  
  /** Returns the name of a HeadTrackMode. */ 
	static const char* getHeadControlModeName(HeadControlModes mode)
	{
		switch(mode)
		{
			case none: return "none";
			case searchForBall: return "searchForBall";
			case searchAuto: return "searchAuto";
			case searchForLandmarks: return "searchForLandmarks";
      case searchForLandmarksHeadLow: return "searchForLandmarksLow"; 
			case lookBetweenFeet: return "lookBetweenFeet";
			case lookLeft: return "lookLeft";
			case lookRight: return "lookRight";
			case lookStraightAhead: return "lookStraightAhead";
			case catchBall: return "catchBall";
			case releaseCaughtBallWhenTurningLeft: return "releaseCaughtBallWhenTurningLeft";
			case releaseCaughtBallWhenTurningRight: return "releaseCaughtBallWhenTurningRight";
			case stayAsForced: return "stayAsForced";
			case lookToStars: return "lookToStars";
			case lookParallelToGround: return "lookParallelToGround";
      case lookTowardOpponentGoal: return "lookTowardOpponentGoal";

      case direct: return "direct";
      case calibrate: return "calibrate";
      case calibrateHeadSpeed: return "calibrateHeadSpeed";
      case watchOrigin: return "watchOrigin";

      case openChallengePullBridge: return "openChallengePullBridge";
      case openChallengeTest: return "openChallengeTest";
      case openChallengeTest2: return "openChallengeTest2";
      case openChallengeGoToBridge: return "openChallengeGoToBridge";
      case openChallengeJoysickMode: return "openChallengeJoysickMode";
      case openChallengeReset: return "openChallengeReset";

      case searchForBallLeft: return "searchForBallLeft";
      case searchForBallRight: return "searchForBallRight";
			default:return "unknown Mode";
		}
	}

  /** Parameters for direct mode */
	long directTilt, directPan, directRoll, directSpeed, directMouth;

};

/**
* Streaming operator that reads a HeadControlMode from a stream.
* @param stream The stream from which is read.
* @param headControlMode The HeadControlMode object.
* @return The stream.
*/ 
In& operator>>(In& stream,HeadControlMode& headControlMode);

/**
* Streaming operator that writes a HeadControlMode to a stream.
* @param stream The stream to write on.
* @param headControlMode The HeadControlMode object.
* @return The stream.
*/ 
Out& operator<<(Out& stream, const HeadControlMode& headControlMode);


#endif //__HeadControlMode_h_

/*
* Change log :
* 
* $Log: HeadControlMode.h,v $
* Revision 1.8  2004/07/02 13:24:23  jhoffman
* - scan for landmarks low (so stuff behind the boarders will not be seen!)
*
* Revision 1.7  2004/07/02 10:27:03  jhoffman
* - preparation for compensating robot motions by appropriate head motion (no actual changes)
* - headControl-Mode added for testing
* - look-at-ball-and-closest-landmark uses quicker head movement
*
* Revision 1.6  2004/07/01 18:21:16  dassler
* Added BasicBehavior and HeadControlMode:
* search-for-ball-left
* search-for-ball-right
* Test is needed
*
* Revision 1.5  2004/06/17 14:34:46  dassler
* GT2004HeadControl updated
* Now looks after propergated ball, followed up withe the communicated ball
* GT2004HeadPathPlanner work now with time optimized moves
* Middle Beacons removed of the Landmarkspercept
*
* Revision 1.4  2004/05/29 18:21:27  dueffert
* walk parameter evolution, measurement and calibration stuff ported to GT2004_WM
*
* Revision 1.3  2004/05/26 12:25:24  juengel
* Added release-ball modes.
*
* Revision 1.2  2004/05/23 12:08:26  loetzsch
* clean up in class HeadControlMode
*
* Revision 1.1.1.1  2004/05/22 17:25:17  cvsadm
* created new repository GT2004_WM
*
* Revision 1.15  2004/05/13 21:56:57  hamerla
* OpenChallenge new Headmode
*
* Revision 1.14  2004/05/10 10:28:53  juengel
* Added mode lookToStarsWhenStepIsFinished
*
* Revision 1.13  2004/05/08 16:18:13  hamerla
* Open Challenge
*
* Revision 1.12  2004/05/03 16:32:35  dassler
* automatic timing optimiting
* head calibration
*
* Revision 1.11  2004/04/08 15:33:07  wachter
* GT04 checkin of Microsoft-Hellounds
*
* Revision 1.10  2004/04/07 13:00:47  risler
* ddd checkin after go04 - second part
*
* Revision 1.3  2004/04/01 20:00:36  Marc
* Update getHeadControlModeName
*
* Revision 1.2  2004/04/01 19:54:56  Marc
* Update getHeadControlModeName
*
* Revision 1.1.1.1  2004/03/29 08:28:45  Administrator
* initial transfer from tamara
*
* Revision 1.9  2004/03/18 23:35:43  hodie
* Some tests of the new HeadControlModes
*
* Revision 1.8  2004/03/17 19:54:03  juengel
* Added kickRight and kickLeft.
*
* Revision 1.7  2004/03/17 16:18:49  thomas
* added preversion of motion optimisation with behaviour, selflocator, headcontrol and robotcontrol dialog
*
* Revision 1.6  2004/03/10 07:59:26  roefer
* New head control mode
*
* Revision 1.5  2004/03/04 16:01:49  fritsche
* added BBautoCatchBall to BB2004HeadControl
*
* Revision 1.4  2004/01/16 15:49:15  dueffert
* headControlMode added
*
* Revision 1.3  2004/01/07 04:09:44  richert
* added HeadControlMode "direct"
*
* Revision 1.2  2003/12/05 14:20:06  jhoffman
* removed unused headcontrolmodes
*
* Revision 1.1  2003/10/07 10:07:01  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.8  2003/09/25 11:23:52  juengel
* Removed BlobCollection.
*
* Revision 1.7  2003/07/07 21:27:39  schumann
* head control bug removed
*
* Revision 1.6  2003/07/07 14:59:35  kudlacik
* Corrected BW-Ball HCM
*
* Revision 1.5  2003/07/07 09:55:15  schumann
* added head control for holding bw-ball
*
* Revision 1.4  2003/07/05 21:36:19  dassler
* Goalie HeadControlMode
* Alle 6 Sek. sich umschauen, wenn Ball weit weg (ber der Mittellinie) alle 3 Sek
*
* Revision 1.3  2003/07/03 10:35:59  roefer
* New head control  mode search-for-lines
*
* Revision 1.2  2003/07/02 16:47:39  dueffert
* lookAroundWhenBallJustCaught added
*
* Revision 1.1.1.1  2003/07/02 09:40:22  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.14  2003/06/30 11:49:44  schmidt
* Corrected search-for-special-ball
*
* Revision 1.13  2003/06/27 13:17:57  jhoffman
* work on obstacle avoider challenge,
* added headcontrolmode,
* added method needed to determine empty space,
* updatet drawing method to reflect actual corridor size
*
* Revision 1.12  2003/06/19 18:32:33  juengel
* no message
*
* Revision 1.11  2003/05/27 15:23:54  loetzsch
* reordered head control modes
*
* Revision 1.10  2003/04/15 15:52:12  risler
* DDD GO 2003 code integrated
*
* Revision 1.7  2003/04/03 14:48:34  dthomas
* added: new HeadControl searchForLandmarksAndBall
* modified: deactivate debug-output for cont. bas. beh.
*
* Revision 1.9  2003/04/07 20:41:01  juengel
* Added lookAroundWhenBallCaught.
*
* Revision 1.8  2003/04/04 15:32:41  jhoffman
* added "scanMid.."
*
* Revision 1.7  2003/04/03 21:07:52  jhoffman
* added "look at ball only"
*
* Revision 1.6  2003/04/01 17:49:10  roefer
* Head control mode catchBall added
*
* Revision 1.5  2003/03/15 22:27:45  juengel
* Added HeadControlMode searchForObstacles.
*
* Revision 1.4  2003/01/09 14:06:52  jhoffman
* added "lookjustbelowhorizon"
*
* Revision 1.3  2002/12/06 10:52:05  kallnik
* Fuzzy Vision
*
* neuer Headcontrol Mode der so schaut, da fr das Weltbild ein mglichst groer Nutzen entsteht
* Doku folgt
*
* Revision 1.2  2002/09/22 18:40:54  risler
* added new math functions, removed GTMath library
*
* Revision 1.1  2002/09/10 15:26:40  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed Challenge Code
* - Removed processing of incoming audio data
* - Renamed AcousticMessage to SoundRequest
*
* Revision 1.17  2002/09/03 16:00:59  juengel
* HeadControlMode follwTail, TailMode stayAsForced.
*
* Revision 1.16  2002/08/22 14:41:03  risler
* added some doxygen comments
*
* Revision 1.15  2002/07/23 13:32:57  loetzsch
* new streaming classes
*
* removed many #include statements
*
* Revision 1.14  2002/06/21 13:28:58  risler
* bar challenge stuff
*
* Revision 1.13  2002/06/20 04:44:52  juengel
* Added HeadControlMode lookAtNextTwoLandmarks.
*
* Revision 1.12  2002/06/17 18:28:22  loetzsch
* added head control mode search-auto
*
* Revision 1.11  2002/06/17 17:18:40  juengel
* Added headControlMode searchForLandmarksInFrontOfRobot.
*
* Revision 1.10  2002/06/13 08:59:50  risler
* head control mode for bar challenge
*
* Revision 1.9  2002/06/12 19:10:48  dueffert
* exactLookAtPoint added
*
* Revision 1.8  2002/06/12 17:54:55  juengel
* Added HeadControlModes searchForLandmarksInCorner and lookAtBallAndNextLandmark.
*
* Revision 1.7  2002/06/08 18:11:28  jhoffman
* added "simple-look-at-point" head control
*
* Revision 1.6  2002/06/04 11:13:26  juengel
* Added HeadControlMode lookAtVisiblePatterns
*
* Revision 1.5  2002/05/27 10:30:19  kosen
* searchForMultipleBalls added
*
* Revision 1.4  2002/05/25 17:37:03  juengel
* 3D and offset for lookAtPoint
*
* Revision 1.3  2002/05/16 09:34:26  kosen
* no message
*
* Revision 1.2  2002/05/15 08:01:37  kosen
* offset in lookAtPoint added
*
* Revision 1.1.1.1  2002/05/10 12:40:13  cvsadm
* Moved GT2002 Project from ute to tamara.
*
* Revision 1.21  2002/05/03 11:49:24  juengel
* GT2002HeadControl created.
*
* Revision 1.20  2002/04/23 10:38:30  risler
* renamed headOdometry to headState
*
* Revision 1.19  2002/04/18 10:25:31  roefer
* Bremen GO
*
* Revision 1.18  2002/04/17 17:04:40  risler
* Darmstadt GO
*
* Revision 1.17  2002/04/17 12:07:35  juengel
* Removed new versions of searchAuto searchForLandmarks and SearchForBall
*
* Revision 1.16  2002/04/16 16:18:31  dueffert
* no message
*
* Revision 1.2  2002/04/11 23:29:38  loetzsch
* added head-control-mode searchForBallWhileDribbling
*
* Revision 1.15  2002/04/09 14:18:29  juengel
* version 2 of some modes
*
* Revision 1.14  2002/03/20 15:15:51  kosen
* lookAtPoint added
*
* Revision 1.13  2002/02/15 15:06:38  kosen
* trackModes in searchModes changes
*
* Revision 1.12  2002/02/12 12:53:12  kosen
* searchLeft and searchRight added
*
* Revision 1.11  2002/02/01 20:44:41  kosen
* changes trackOnlyBall to trackForBall
*
* Revision 1.10  2002/01/23 23:25:32  roefer
* SimGT2002 console now accepts input
*
* Revision 1.9  2002/01/19 21:36:27  risler
* added HeadMotionTester, HeadControlSelector
*
* Revision 1.8  2002/01/18 13:34:36  risler
* enum style
*
* Revision 1.7  2002/01/18 13:29:51  risler
* removed trackNothing
*
* Revision 1.6  2002/01/06 13:49:55  juengel
* HeadControlModes lookStraihtAhead und stayAsForced eingefhrt.
*
* Revision 1.5  2001/12/10 17:47:05  risler
* change log added
*
*/
