/**
 * @file HeadControlMode.cpp
 * 
 * Based on old implementation of HeadControlMode from GT2001
 *
 * Implementation of class HeadControlMode
 * Stores head modes requested by BehaviorControl
 *
 * @author Matthias Juengel
 * @author Nils Koschmieder
 */ 

#include "HeadControlMode.h"


HeadControlMode::HeadControlMode()
: headControlMode(none), directTilt(0), directPan(0), directRoll(0), directSpeed(400), directMouth(0)
{
}

HeadControlMode::~HeadControlMode()
{
}

In& operator>>(In& stream,HeadControlMode& headControlMode)
{
  stream.read(&headControlMode,sizeof(HeadControlMode));
  return stream;
}
 
Out& operator<<(Out& stream, const HeadControlMode& headControlMode)
{
  stream.write(&headControlMode,sizeof(HeadControlMode));
  return stream;
}

/*
 * Change log :
 * 
 * $Log: HeadControlMode.cpp,v $
 * Revision 1.2  2004/05/23 12:08:26  loetzsch
 * clean up in class HeadControlMode
 *
 * Revision 1.1.1.1  2004/05/22 17:25:16  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.2  2004/01/07 04:09:44  richert
 * added HeadControlMode "direct"
 *
 * Revision 1.1  2003/10/07 10:07:01  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.2  2003/07/30 14:57:13  dueffert
 * initialization of member variables added
 *
 * Revision 1.1.1.1  2003/07/02 09:40:22  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.2  2002/10/14 13:14:24  dueffert
 * doxygen comments corrected
 *
 * Revision 1.1  2002/09/10 15:26:40  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed Challenge Code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.1.1.1  2002/05/10 12:40:13  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.6  2002/01/23 23:25:32  roefer
 * SimGT2002 console now accepts input
 *
 * Revision 1.5  2001/12/10 17:47:05  risler
 * change log added
 *
 */
