/**
 * @file JoystickData.h
 * Declaration of class JoystickData.
 *
 * @author <a href=mailto:dueffert@informatik.hu-berlin.de>Uwe Dffert</a>
 */

#ifndef __JOYSTICKDATA_H__
#define __JOYSTICKDATA_H__

#include "Representations/Motion/MotionRequest.h"
#include "Tools/Streams/InOut.h"

/** the maximum number of configurable buttons */
static const int numOfJoystickButtons = 12;

/**
 * @class JoystickData
 * A class for holdung all data produced by a joystick or a key equivalent.
 */
class JoystickData
{
public:
  /** Constructor */
  JoystickData();

	/** The value of the three joystick axes in [-1,1] */
	double x,y,z;

	/** The value of the accelerator in [0,1] */
	double accel;
	
	/** Bit array of the pressed buttons */
	int button;
	
	/** The value of the coolie: 0 or 1..8 */
	int coolie;

	/** Boolean if a special-action is given to be executed */
	bool directSpecialAction;
	
	/** The id of the special-action to be executed directly */
	SpecialActionRequest::SpecialActionID specialActionID;
	
  /** 
  * The timestamp when the last data was received.
  * Note that this value is set in the In streaming operator.
  */
  unsigned long timeStamp;
};

/**
 * Streaming operator that reads a JoystickData from a stream.
 * @param stream The stream from which is read.
 * @param joystickData The JoystickData object.
 * @return The stream.
 */ 
In& operator>>(In& stream,JoystickData& joystickData);
 
/**
 * Streaming operator that writes a JoystickData to a stream.
 * @param stream The stream to write on.
 * @param joystickData The JoystickData object.
 * @return The stream.
 */ 
Out& operator<<(Out& stream, const JoystickData& joystickData);

#endif // __JOYSTICKDATA_H__

/*
 * Changelog:
 * 
 * $Log: JoystickData.h,v $
 * Revision 1.2  2004/06/02 17:18:24  spranger
 * MotionRequest cleanup
 *
 * Revision 1.1.1.1  2004/05/22 17:25:01  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.2  2004/04/26 15:58:59  thomas
 * added new project RobotRemote based on ATHAiboControl
 *
 * Revision 1.1  2003/10/07 10:07:01  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:22  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.3  2003/02/27 12:56:54  dueffert
 * doxygen error removed
 *
 * Revision 1.2  2003/02/27 12:33:57  dueffert
 * doxygen warning removed
 *
 * Revision 1.1  2003/02/27 12:02:11  dueffert
 * JoystickData added
 *
 *
 */
