/**
 * @file JoystickData.cpp
 * Implementation of class JoystickData.
 *
 * @author <a href=mailto:dueffert@informatik.hu-berlin.de>Uwe Dffert</a>
 */

#include "JoystickData.h"
#include "Platform/SystemCall.h"
#include "Representations/Motion/MotionRequest.h"

JoystickData::JoystickData():x(0),y(0),z(0),accel(0),button(0),coolie(0),directSpecialAction(false),specialActionID(SpecialActionRequest::numOfSpecialAction)
{
  timeStamp = SystemCall::getCurrentSystemTime();
}

In& operator>>(In& stream,JoystickData& joystickData)
{
  joystickData.timeStamp = SystemCall::getCurrentSystemTime();
  int directSpecialAction, specialActionID;
  stream >> joystickData.x >> joystickData.y >> joystickData.z >> joystickData.accel >> joystickData.button >> joystickData.coolie >> directSpecialAction >> specialActionID;
  joystickData.directSpecialAction = directSpecialAction!=0;
  joystickData.specialActionID = (SpecialActionRequest::SpecialActionID)specialActionID;
  return stream;
}
 
Out& operator<<(Out& stream, const JoystickData& joystickData)
{
  stream << joystickData.x << joystickData.y << joystickData.z << joystickData.accel << joystickData.button << joystickData.coolie << (int)joystickData.directSpecialAction << (int)joystickData.specialActionID;
  return stream;
}

/*
 * Changelog:
 * 
 * $Log: JoystickData.cpp,v $
 * Revision 1.2  2004/06/02 17:18:24  spranger
 * MotionRequest cleanup
 *
 * Revision 1.1.1.1  2004/05/22 17:25:01  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.2  2004/04/26 15:58:59  thomas
 * added new project RobotRemote based on ATHAiboControl
 *
 * Revision 1.1  2003/10/07 10:07:01  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:22  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.1  2003/02/27 12:02:11  dueffert
 * JoystickData added
 *
 *
 */
