/**
 * @file LandmarksState.h
 * 
 * Declaration of class LandmarksState
 */ 

#ifndef __LandmarksState_h_
#define __LandmarksState_h_


#include "Tools/Streams/InOut.h"
#include "Representations/Perception/LandmarksPercept.h"
#include "Representations/Cognition/LandmarkState.h"




/**
 * A class describing detected landmarks
 */
class LandmarksState
{


public:

  LandmarksState();

  static const double BEACON;
  static const double GOAL;
  static const double LINE;
  static const double EDGE;


  enum {numOfLandmarks = 13};

  LandmarkState landmarks[numOfLandmarks];

  /** the index of the last seen beacon */
  int lastSeenBeacon;

  void update (const LandmarksPercept& landmarksPercept);
  void reset();

	/** return true, if a beacon was seen */
  bool seenAnyBeacon() const;
  /** return true, if a beacon or a flag was seen */
  bool seenAnyFlag() const;
  
  /** return the index of the last seen landmark. this is useful for optimizing the next two functions */
  int lastSeenBeaconIndex() const;

  /** return the time when the last beacon was seen. the function sets up the var lastSeenBeacon */
  long timeOfLastSeenBeacon(int beaconIndex) const;
  
  /** return the time difference between the two last seen beacon */
  long timeBetweenSeen2LastBeacons(int beaconIndex) const;
  void initLandmarks();
  void setLandmarkVisibleByBeaconType(int type);
};

/**
 * Streaming operator that reads a LandmarksState from a stream.
 * @param stream The stream from which is read.
 * @param robotState The LandmarksState object.
 * @return The stream.
 */ 
In& operator>>(In& stream,LandmarksState& landmarksState);
 
/**
 * Streaming operator that writes a LandmarksState to a stream.
 * @param stream The stream to write on.
 * @param robotState The LandmarksState object.
 * @return The stream.
 */ 
Out& operator<<(Out& stream, const LandmarksState& landmarksState);


#endif //__LandmarksState_h_

/*
 * Change log :
 * 
 */
