/**
 * @file LandmarkState.h
 * 
 * Declaration of class LandmarkState
 */ 

#ifndef __LandmarkState_h_
#define __LandmarkState_h_


#include "Tools/Streams/InOut.h"
#include "Tools/FieldDimensions.h"
#include "Representations/Perception/LandmarksPercept.h"

/**
 * A class describing a landmark
 */
class LandmarkState
{

public:

  // exact 3d position of the landmark
	Vector3<double> position;
  // the weight of a landmark. this is used to decide which landmark is used for the gaze
  // of the HeadControl

  enum type
        {Beacon,
        Goal,
        Line,
        Edge};

  int beaconColor;


  bool visible;
  long timeWhenLastSeen;
  double typeWeight;


  LandmarkState() { }

  LandmarkState(Vector3<double> pposition,int bbeaconColor,double wweight);
  
};

/**
 * Streaming operator that reads a LandmarkState from a stream.
 * @param stream The stream from which is read.
 * @param robotState The LandmarkState object.
 * @return The stream.
 */ 

In& operator>>(In& stream,LandmarkState& landmarkState);

/**
 * Streaming operator that writes a LandmarkState to a stream.
 * @param stream The stream to write on.
 * @param robotState The LandmarkState object.
 * @return The stream.
 */ 
Out& operator<<(Out& stream, const LandmarkState& landmarkState);


#endif //__LandmarkState_h_

/*
 * Change log :
 * $Log: LandmarkState.h,v $
 * Revision 1.2  2004/06/28 09:46:57  dassler
 * introduced some more headcontrol symbols
 * time-since-last-seen-beacon
 * time-between-last-beacons
 *
 * Revision 1.1  2004/06/17 15:45:28  dassler
 * Added LandmarkState
 *
 */
