/**
* @file LandmarkState.cpp
*
* Implementation of class LandmarkState.
*
* @author <A href=mailto:marc.dassler@web.de>Marc Dassler</A>
*/



#include "LandmarkState.h"


LandmarkState::LandmarkState(Vector3<double> pposition,int bbeaconColor,double wweight)
{
  position = pposition;
  typeWeight = wweight;
  beaconColor = bbeaconColor;
}

/**
 * Streaming operator that reads a LandmarkState from a stream.
 * @param stream The stream from which is read.
 * @param robotState The LandmarkState object.
 * @return The stream.
 */ 

In& operator>>(In& stream,LandmarkState& landmarkState)
{
  stream.read(&landmarkState,sizeof(LandmarkState));
  return stream;
}

/**
 * Streaming operator that writes a LandmarkState to a stream.
 * @param stream The stream to write on.
 * @param robotState The LandmarkState object.
 * @return The stream.
 */ 
Out& operator<<(Out& stream, const LandmarkState& landmarkState)
{
  stream.write(&landmarkState,sizeof(LandmarkState));
  return stream;
}


/*
* Change log :
*
* $Log: LandmarkState.cpp,v $
* Revision 1.1  2004/06/17 15:45:28  dassler
* Added LandmarkState
*
*
*/
