/**
 * @file Landmark.h
 * 
 * Declaration of class Landmark
 */ 

#ifndef __Landmark_h_
#define __Landmark_h_


#include "Tools/Streams/InOut.h"
#include "Representations/Perception/LandmarksPercept.h"

/**
 * A class describing a landmark
 */
class Landmark
{

public:

	Vector3d<double> landmarkPosition;
	double weight = 0; // Values e[0,1]

  enum {Beacon,
        Goal,
        Line,
        Edge} type;
  
  enum {none,
        pinkOverYellow,
        yellowOverPink,
        skyblueOverPink,
        pinkOverSkyblue} beconColor;
  
  enum {none,
        frontLeftFlag,
        frontRightFlag,
        backLeftFlag,
        backRightFlag,
        ownGoal,
        opponentGoal} beaconPosition;
           
  bool isUsedInActiveScan;

  bool flagVisible;

  void reset();

};

/**
 * Streaming operator that reads a Landmark from a stream.
 * @param stream The stream from which is read.
 * @param robotState The Landmark object.
 * @return The stream.
 */ 
In& operator>>(In& stream,Landmark& landmark);
 
/**
 * Streaming operator that writes a Landmark to a stream.
 * @param stream The stream to write on.
 * @param robotState The Landmark object.
 * @return The stream.
 */ 
Out& operator<<(Out& stream, const Landmark& landmark);


#endif //__Landmark_h_

/*
 * Change log :
 * $Log: Landmark.h,v $
 * Revision 1.1  2004/06/17 15:45:28  dassler
 * Added LandmarkState
 *
 */
