/**
* @file PackageMotionCognition.h
*
* Definition of class PackageMotionCognition.
*
* @author Martin Ltzsch
*/

#ifndef __PackageMotionCognition_h_
#define __PackageMotionCognition_h_

#include "Representations/Motion/MotionInfo.h"

/**
* @class PackageMotionCognition
*
* Contains all data that are sent from the Motion process to the Cognition process
* in the CMD process layout.
*
* @author Martin Ltzsch
*/
class PackageMotionCognition
{
public:
  /** The time when the package was sent */
  unsigned long timeStamp;

  /** the MotionRequest that is currently executed be the MotionControl */
  MotionInfo motionInfo;
};

/**
* Streaming operator that reads a PackageMotionCognition from a stream.
* @param stream The stream from which is read.
* @param packageMotionCognition The PackageMotionCognition object.
* @return The stream.
*/ 
In& operator>>(In& stream, PackageMotionCognition& packageMotionCognition);

/**
* Streaming operator that writes a PackageMotionCognition to a stream.
* @param stream The stream to write on.
* @param packageMotionCognition The PackageMotionCognition object.
* @return The stream.
*/ 
Out& operator<<(Out& stream, const PackageMotionCognition& packageMotionCognition);


#endif //__PackageMotionCognition_h_

/*
* Change Log:
*
* $Log: PackageMotionCognition.h,v $
* Revision 1.3  2004/06/17 17:27:56  spranger
* added timestamp to package
*
* Revision 1.2  2004/05/26 17:31:34  dueffert
* better data types used
*
* Revision 1.1.1.1  2004/05/22 17:25:01  cvsadm
* created new repository GT2004_WM
*
* Revision 1.1  2003/10/07 10:07:01  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.2  2003/09/26 15:30:39  juengel
* Renamed DataTypes to representations.
*
* Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.5  2003/05/13 12:04:45  goehring
* JointState removed
*
* Revision 1.4  2003/04/25 19:49:56  goehring
* Added JointState
*
* Revision 1.3  2002/09/18 19:52:36  loetzsch
* the head state is now sent from Motion to Cognition using the package.
*
* Revision 1.2  2002/09/17 23:55:22  loetzsch
* - unraveled several datatypes
* - changed the WATCH macro
* - completed the process restructuring
*
* Revision 1.1  2002/09/11 13:42:54  loetzsch
* Created a package for all data that are sent from Motion to Cognition
*
*/
