/**
* @file PackageMotionCognition.cpp
*
* Implementation of class PackageMotionCognition.
*
* @author Martin Ltzsch
*/

#include "PackageMotionCognition.h"

In& operator>>(In& stream, PackageMotionCognition& packageMotionCognition)
{
  stream     >> packageMotionCognition.timeStamp
             >> packageMotionCognition.motionInfo;
  return stream;
}

Out& operator<<(Out& stream, const PackageMotionCognition& packageMotionCognition)
{
  stream     << packageMotionCognition.timeStamp 
             << packageMotionCognition.motionInfo;
    
  return stream;
}

/*
* Change Log:
*
* $Log: PackageMotionCognition.cpp,v $
* Revision 1.3  2004/06/17 17:27:56  spranger
* added timestamp to package
*
* Revision 1.2  2004/05/26 17:31:34  dueffert
* better data types used
*
* Revision 1.1.1.1  2004/05/22 17:25:01  cvsadm
* created new repository GT2004_WM
*
* Revision 1.1  2003/10/07 10:07:01  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.5  2003/05/13 12:04:45  goehring
* JointState removed
*
* Revision 1.4  2003/04/25 19:49:56  goehring
* Added JointState
*
* Revision 1.3  2002/09/18 19:52:36  loetzsch
* the head state is now sent from Motion to Cognition using the package.
*
* Revision 1.2  2002/09/17 23:55:22  loetzsch
* - unraveled several datatypes
* - changed the WATCH macro
* - completed the process restructuring
*
* Revision 1.1  2002/09/11 13:42:54  loetzsch
* Created a package for all data that are sent from Motion to Cognition
*
*/
