/** 
* @file Processes/CMD/Debug.h
* 
* Declaration of class Debug.
*
* @author Martin Ltzsch
*/

#ifndef __Debug_h_
#define __Debug_h_

#include "Tools/Process.h"
#include "Platform/TCPHandler.h"
//#include "Platform/Aperios1.3.2/TCPEndpoint.h"
#include "Tools/Debugging/QueueFillRequest.h"

/**
* @class Debug
* 
* A process for collection and distribution of debug messages.
*
* All messages from the processes to the PC are collected here and all messages from the 
* PC to the processes are distributed by the Debug process.
*
* @author Martin Ltzsch
*/
class Debug : public Process
{
private:
  //DEBUGGING;
  EXTERNAL_DEBUGGING;
  DEBUG_RECEIVER(Cognition);
  DEBUG_RECEIVER(Motion);
  DEBUG_SENDER(Cognition);
  DEBUG_SENDER(Motion);

public:
  
  /** Constructor */
  Debug();

  /** Destructor */
  ~Debug();
  
  /** The main function of the process */
  int main();

  /** Is called before the first main() */
  virtual void init();

  /** 
  * Is called for every incoming debug message.
  * @param message the message to handle
  * @return if the message was handled
  */
  virtual bool handleMessage(InMessage& message);

  /**
  * The QueueFillMode for the outgoing Queue
  */
  QueueFillRequest::QueueFillMode mode;
	
  /**
  * The time when the outgoing queue is written to the stick or allowed to be accessed via wlan
  */
  unsigned long saveOrSendTime;

private:
  /** If true, a message was received from the WLan or OVirtualRobotComm */
  bool messageWasReceived;
};

#endif // __Debug_h_

/*
 * Change log :
 * 
 * $Log: Debug.h,v $
 * Revision 1.1.1.1  2004/05/22 17:24:57  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.4  2004/02/24 13:30:20  kindler
 * - requests.dat is now only read once, and is no longer held open.
 *
 * Revision 1.3  2004/01/03 19:15:17  wachter
 * Debug-communication without router working now
 *
 * Revision 1.2  2003/11/29 07:40:19  roefer
 * Doxygen comments corrected
 *
 * Revision 1.1  2003/10/07 10:07:01  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.2  2003/09/26 11:41:17  juengel
 * - sorted tools
 * - clean-up in DataTypes
 *
 * Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.7  2003/01/21 15:35:18  loetzsch
 * on the robot messages now are only sent if a message was received from the PC
 *
 * Revision 1.6  2003/01/10 15:48:20  loetzsch
 * added a hack that does not send any messages to the WLan or OVirtualRobotComm
 * in the first 5 seconds after the first execution of main()
 *
 * Revision 1.5  2002/11/27 13:50:27  dueffert
 * QueueFillMode beautified
 *
 * Revision 1.4  2002/11/25 12:27:15  dueffert
 * first steps towards reading growing files
 *
 * Revision 1.3  2002/11/19 12:57:54  dueffert
 * queuefillrequest added, debugkey toolbar extended, memorystick toolbar removed
 *
 * Revision 1.2  2002/11/18 10:35:05  juengel
 * Added "block debug sender" mechanism
 *
 * Revision 1.1  2002/09/10 15:41:25  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 * - Removed all process layouts
 * - Added process layout CMD
 *
 * Revision 1.3  2002/07/23 13:40:51  loetzsch
 * - new streaming classes
 * - removed many #include statements
 * - new design of debugging architecture
 * - exchanged StaticQueue with MessageQueue
 * - new debug message handling
 * - general clean up
 *
 * Revision 1.2  2002/05/16 22:36:11  roefer
 * Team communication and GTMath bugs fixed
 *
 * Revision 1.12  2002/04/10 11:09:19  piepenstock
 * added platform dependable SerialComm-Files
 *
 * Revision 1.11  2002/03/27 12:58:12  piepenstock
 * Added serial communication support
 *
 * Revision 1.10  2002/02/05 20:02:16  risler
 * handleDebugMessage now returns bool, added debug message handling to ImageProcessor
 *
 * Revision 1.9  2002/01/30 17:29:56  loetzsch
 * handleDebugMessage um Parameter timestamp erweitert
 *
 * Revision 1.8  2001/12/20 17:14:35  loetzsch
 * Using debug requests from the memory stick.
 *
 * Revision 1.7  2001/12/15 20:32:09  roefer
 * Senders and receivers are now part of the processes
 *
 * Revision 1.6  2001/12/14 12:34:09  dueffert
 * no message
 *
 * Revision 1.5  2001/12/12 18:08:56  loetzsch
 * Streaming- Operatoren fr Bilder eingebaut, DebugKeyTable nicht- statisch gemacht, Debuggin Mechanismen weitergemacht, Bilder aus Logfiles in RobotControl anzeigen, Logfiles in HU1/Debug auf den Stick schreiben
 *
 * Revision 1.4  2001/12/10 17:47:08  risler
 * change log added
 *
 */
