/**
* @file Platform/Win32/Sensors.cpp
*
* Declaration of class Sensors and streaming operators for images and sensor data
* for SimRobot platform
*
* @author Thomas Rfer
* @author Martin Ltzsch
* @author Joscha Bach
*/

#include "Sensors.h"

In& operator>>(In& stream,Image& image) 
{
  stream 
    >> image.cameraInfo.resolutionWidth 
    >> image.cameraInfo.resolutionHeight 
    >> image.frameNumber;

  image.setCameraInfo();
	
  for(int y = 0; y < image.cameraInfo.resolutionHeight; ++y)
    for(int c = 0; c < 6; ++c)
      stream.read(&image.image[y][c][0], image.cameraInfo.resolutionWidth);
	return stream;
}

In& operator>>(In& stream,SensorDataBuffer& sensorDataBuffer)
{
  stream >> sensorDataBuffer.numOfFrames;
  for (int i=0;i<sensorDataBuffer.numOfFrames;i++)
  {
    stream >> sensorDataBuffer.frame[i];
  }

  return stream;
}
/*
* Change log :
* 
* $Log: Sensors.cpp,v $
* Revision 1.1.1.1  2004/05/22 17:24:14  cvsadm
* created new repository GT2004_WM
*
* Revision 1.7  2004/04/07 13:00:46  risler
* ddd checkin after go04 - second part
*
* Revision 1.3  2004/04/07 11:44:07  risler
* added sending low res images
* added Image::setCameraInfo
*
* Revision 1.2  2004/03/29 15:19:04  Marc
* Intruduced the Black and White Image
* Normal Images (not Jpeg) images were now send as Color Image with BW
*
* Revision 1.6  2004/03/17 12:35:13  nistico
* Fixed problem with loading of intrinsic camera parameters
*
* Revision 1.5  2004/02/12 14:21:49  nistico
* Calculated refined (4 robots used) intrinsic camera parameters for ERS-7
* Fixed bug with ERS-7 logfiles and intrinsic camera parameters (formerly, they weren't correctly associated
* with the higher resolution image from the new robot)
*
* Revision 1.4  2003/12/31 23:50:39  roefer
* Removed inclusion of RobotDimensions.h because it is not used
*
* Revision 1.3  2003/12/30 20:12:03  roefer
* Image size is now 208 x 160. Smaller images are placed in the upper left corner
*
* Revision 1.2  2003/12/15 11:49:09  juengel
* Introduced CameraInfo
*
* Revision 1.1  2003/10/07 10:06:59  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.3  2003/05/02 18:26:18  risler
* SensorDataBuffer added
* replaced SensorData with SensorDataBuffer
* full SensorData resolution now accessible
*
* Revision 1.2  2002/09/17 23:55:22  loetzsch
* - unraveled several datatypes
* - changed the WATCH macro
* - completed the process restructuring
*
* Revision 1.1  2002/09/10 15:40:05  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
* - Removed processing of incoming audio data
* - Renamed AcousticMessage to SoundRequest
*
* Revision 1.2  2002/05/14 21:07:17  hebbel
* in operator for SoundDataIn included
*
* Revision 1.1.1.1  2002/05/10 12:40:18  cvsadm
* Moved GT2002 Project from ute to tamara.
*
* Revision 1.4  2002/04/03 14:18:52  juengel
* camera matrix and odometry data added to streaming operator for images
*
* Revision 1.3  2002/04/03 12:49:37  juengel
* camera matrix and odometry data added to streaming operator for images
*
* Revision 1.2  2002/01/14 22:50:28  loetzsch
* SimRobot / RobotControl integration started
*
* Revision 1.1  2001/12/29 03:33:16  roefer
* SimGT2002 inserted
*
* Revision 1.1  2001/12/19 16:03:55  bach
* SystemDataTypes replaced by Sensors
*
*
*/
