/**
 * @file Platform/Win32/RouterCtrl.h
 *
 * This file declares the class RouterCtrl.
 *
 * @author <A href=mailto:roefer@tzi.de>Thomas Rfer</A>
 */
#ifndef __RouterCtrl_H__
#define __RouterCtrl_H__

#include "Thread.h"

/**
 * The class controls the router connecting Windows processes to the real robots.
 */
class RouterCtrl : public Thread<RouterCtrl>
{
  private:
    HANDLE hRouter; /**< The handle of the pipe from the router. */

    /**
     * The function handles the communication with the router.
     */
    void main();

  public:
    /**
     * Destructor.
     */
    ~RouterCtrl() {stop();}

    /**
     * The function starts the router with the given parameters.
     * @param params The parameters for the router.
     */
    void start(const char* params);

    /**
     * The function stops the router if it is running.
     */
    void stop();

  protected:
    /**
     * The function is called for each line received from the router.
     * As it is called from a different thread, it must take synchronisation
     * into account.
     * @param line The line of text that has been received.
     */
    virtual void onLineReceived(const char* line) {}
};

#endif

/*
 * Change log :
 *
 * $Log: RouterCtrl.h,v $
 * Revision 1.1.1.1  2004/05/22 17:24:13  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.1  2003/10/07 10:06:59  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.1  2002/09/10 15:40:05  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.1  2002/08/01 12:52:26  roefer
 * RouterCtrl and TcpConnection added
 *
 *
 */
