/**
 * @file Platform/Win32/ProcessFramework.cpp
 *
 * This file implements classes corresponding to the process framework.
 *
 * @author <A href=mailto:roefer@tzi.de>Thomas Rfer</A>
 */
#ifndef SIMROBOT
#include "RoboCupCtrl.h"
#else
#include "RoboCupCtrl2.h"
#endif
#include "Platform/ProcessFramework.h"

/*
 * ProcessCreatorBase::list must be initialized before any code generated
 * by MAKE_PROCESS is executed. Therefore, early initialization is forced.
 */
#pragma warning(disable:4073)
#pragma init_seg(lib)
List<ProcessCreatorBase*> ProcessCreatorBase::list;
int ProcessList::numberOfProcesses = 0;

void PlatformProcess::setBlockingId(int id,bool block)
{
  if(block)
    blockMask |= 1 << id;
  else
    blockMask &= ~(1 << id);
}

void PlatformProcess::setEventId(int id)
{
  eventMask |= 1 << id; // id == 0 -> Always accept theDebugReceiver
  if(!id || blockMask && (eventMask & blockMask) == blockMask)
  {
    blockMask = 0;
    nextFrame();
  }
}

int PlatformProcess::getIndex()
{
  return RoboCupCtrl::getController()->getProcessIndex();
}

int PlatformProcess::getRobotIndex()
{
  return RoboCupCtrl::getController()->getRobotIndex();
}

/*
 * Change Log:
 *
 * $Log: ProcessFramework.cpp,v $
 * Revision 1.1.1.1  2004/05/22 17:23:56  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.3  2003/10/26 08:57:15  roefer
 * Symbol SIMROBXP removed
 *
 * Revision 1.2  2003/10/14 07:34:16  roefer
 * Support files for SimRobXP added, not finished yet
 *
 * Revision 1.1  2003/10/07 10:06:59  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.2  2002/12/07 16:40:45  roefer
 * Blocking for theDebugReceiver changed
 *
 * Revision 1.1  2002/09/10 15:40:05  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.2  2002/06/28 10:26:21  roefer
 * OUTPUT is possible in constructors
 *
 * Revision 1.1.1.1  2002/05/10 12:40:18  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.7  2002/05/05 14:06:42  roefer
 * SimGT2002 processes block as the ones on Aperios
 *
 * Revision 1.6  2002/04/20 15:52:20  roefer
 * Project simpified, WATCH and WATCH_PART added
 *
 * Revision 1.6  2002/04/06 09:55:53  roefer
 * Image and SensorData path through DebugQueues changed
 *
 * Revision 1.5  2002/02/05 18:08:40  roefer
 * PlatformProcess::getRobotIndex() inserted
 *
 * Revision 1.4  2002/01/16 10:51:53  roefer
 * Process index table is cleared on restart of simulation
 *
 * Revision 1.3  2002/01/15 23:54:15  loetzsch
 * SolutionRequest introduced
 *
 *
 */