/**
 * @file Platform/Win32/Oracle.h
 *
 * This file declares the magic Oracle that knows everything.
 *
 * @author <A href=mailto:roefer@tzi.de>Thomas Rfer</A>
 */

#ifndef __Oracle_H__
#define __Oracle_H__

#include "Representations/Cognition/RobotPose.h"
#include "Representations/Cognition/PlayerPoseCollection.h"
#include "Representations/Cognition/BallModel.h"
#include "Representations/Cognition/ObstaclesModel.h"
#include "Tools/Field.h"

class SIM3DElement;

/**
 * This the magic Oracle that knows everything.
 * Derivations for real world applications will be implemented later.
 */
class Oracle
{
  private:
    static Field field; /**< A model of the field. */

    /**
     * The function determines whether the specified object is blue.
     * @param obj The object that is checked for being blue.
     * @return Is the object red?
     */
    static bool isBlue(SIM3DElement* obj);

    /**
     * The function inserts a robot into a player pose collection.
     * @param ppc The player pose collection.
     * @param me The robot associated with the current process.
     * @param obj The robot that shall be added.
     * @param currentFrameNumber The frame number to be written into the player pose.
     */
    static void addPlayer(PlayerPoseCollection& ppc,SIM3DElement* me,SIM3DElement* obj,unsigned currentFrameNumber);

  public:
    /**
     * The function returns the pose of a robot associated with the current process.
     * @param currentFrameNumber The frame number to be written into the robot pose.
     * @return The robot's current pose.
     */
    static RobotPose getRobotPose(unsigned currentFrameNumber);

    /**
     * The function returns the player pose collection for the robot associated with the current process.
     * @param currentFrameNumber The frame number to be written into the player poses.
     * @return The player pose collection.
     */
    static PlayerPoseCollection getPlayerPoseCollection(unsigned currentFrameNumber);

    /**
     * The function returns the ball's position for the robot associated with the current process.
     * @param currentFrameNumber The frame number to be written into the ball position.
     * @return The ball's position.
     */
    static BallModel getBallModel(unsigned currentFrameNumber);

    /**
     * The function returns the obstacle model for a robot.
     * @param pose The pose of the robot.
     * @param ppc The poses of the other players.
     * @return The obstacle model.
     */
    static ObstaclesModel getObstaclesModel(const RobotPose& pose, const PlayerPoseCollection& ppc);
};

#endif


/*
 * Change log :
 * 
 * $Log: Oracle.h,v $
 * Revision 1.2  2004/05/22 22:52:04  juengel
 * Renamed ballP_osition to ballModel.
 *
 * Revision 1.1.1.1  2004/05/22 17:23:56  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.4  2004/02/03 13:19:49  spranger
 * renamed all references to  class BallP_osition to BallModel
 *
 * Revision 1.3  2003/11/18 15:44:31  dueffert
 * Oracle now cares about frame numbers
 *
 * Revision 1.2  2003/10/23 15:41:40  roefer
 * Oracled obstacle model added
 *
 * Revision 1.1  2003/10/07 10:06:59  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.2  2003/09/26 15:30:28  juengel
 * Renamed DataTypes to representations.
 *
 * Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.3  2002/11/27 13:50:06  dueffert
 * doxygen docu added
 *
 * Revision 1.2  2002/09/25 12:05:44  loetzsch
 * removed BarPercept and PatternPercept
 *
 * Revision 1.1  2002/09/10 15:40:05  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.3  2002/06/13 11:43:15  risler
 * bar oracle
 *
 * Revision 1.2  2002/06/07 09:29:05  kosen
 * Oracle paints now multipleBalls.
 *
 * Revision 1.1.1.1  2002/05/10 12:40:18  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.4  2002/02/06 18:57:58  roefer
 * Simplifications for oracle and debug drawings
 *
 * Revision 1.3  2002/02/05 14:04:30  roefer
 * Oracle has optional parameter for referred robot
 *
 * Revision 1.2  2002/01/25 16:10:48  roefer
 * Comments inserted
 *
 * Revision 1.3  2001/12/10 17:47:07  risler
 * change log added
 *
 */
