/**
* @file TimeView.h
*
* Declaration of class TimeView
*
* @author <a href="mailto:roefer.tzi.de">Thomas Rfer</a>
*/

#ifndef __TimeView_h_
#define __TimeView_h_

#include "RobotConsole.h"

/**
* @class TimeView 
* 
* A class to represent a view with information about the timing of modules.
*
* @author <a href="mailto:roefer.tzi.de">Thomas Rfer</a>
*/
class TimeView : public DirectView
{
  private:
    RobotConsole& console; /**< A reference to the console object. */
    const TimeInfo& info; /**< The Xabsl2 info structure. */
    static double leftOfColumnPercent[5]; /**< Ratios for the beginning of the columns. */
    CFont normalFont, /**< Normal font. */
          boldFont; /**< Bold font. */
    CDC* dc; /**< The current device context. */
    int line, /**< A line counter in pixels. */
        width, /**< The width of the view in pixels. */
        lineHeight; /**< The height of a line in pixels. */
  
    /**
    * The function prints a string to a certain column in the view.
    * @param s The string.
    * @param column A column index.
    * @param bold Should the string be printed in boldface?
    */    
    void print(const std::string& s, int column, bool bold = false);

    /**
    * The function sets the print position to the next line.
    * @param drawLine Should a line be drawn between the lines?
    */
    void newLine(bool drawLine = false);

  public:
    /**
    * Constructor.
    * @param c The console object.
    * @param i The Xabs2 info object to be visualized.
    */
    TimeView(RobotConsole& c, const TimeInfo& i);

    /**
    * Destructor.
    */
    ~TimeView();

    /**
    * The function is called to draw the view.
    * @param dc The device context to draw to.
    */
    void draw(CDC& dc);
};

#endif //__TimeView_h_

/*
 * Change log :
 * 
 * $Log: TimeView.h,v $
 * Revision 1.1.1.1  2004/05/22 17:24:34  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.1  2004/04/09 18:55:16  roefer
 * Better structure for views
 * cp command added
 * Timing view added
 *
 */
