/**
* @file TimeView.cpp
*
* Implementation of class TimeView
*
* @author <a href="mailto:roefer.tzi.de">Thomas Rfer</a>
*/

#include "TimeView.h"

double TimeView::leftOfColumnPercent[5] =
{
  0, 0.55, 0.7, 0.85, 1.0
};

TimeView::TimeView(RobotConsole& c, const TimeInfo& i)
: console(c),
  info(i)
{
  normalFont.CreateFont(14,0,0,0,FW_NORMAL,FALSE,FALSE,0,ANSI_CHARSET,
    OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,
    DEFAULT_PITCH | FF_SWISS,"Arial");

  boldFont.CreateFont(14,0,0,0,FW_BOLD,FALSE,FALSE,0,ANSI_CHARSET,
    OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,
    DEFAULT_PITCH | FF_SWISS,"Arial");
}

TimeView::~TimeView()
{
  boldFont.DeleteObject();
  normalFont.DeleteObject();
}

void TimeView::draw(CDC& dc)
{
  this->dc = &dc;
  line = 0;
  CFont* oldFont = dc.SelectObject(&normalFont);
  if(GetDeviceCaps(dc.m_hDC,TECHNOLOGY) != DT_METAFILE)
  {
    width = dc.GetViewportExt().cx;
    lineHeight = dc.GetTextExtent("M").cy;
  }
  else
  {
    width = 400;
    lineHeight = 14;
  }
  dc.SetMapMode(MM_TEXT);
  dc.SetBkMode(TRANSPARENT);
  SYNC_WITH(console);
  print("Module",0,true);
  print("Min",1,true);
  print("Max",2,true);
  print("Avg",3,true);
  print("Freq",4,true);
  newLine(true);
  for(int i = 0; i < Stopwatch::numberOfStopwatchEventIDs; ++i)
  {
    double minTime,
           maxTime,
           avgTime,
           freq;
    if(info.getStatistics(Stopwatch::StopwatchEventID(i), minTime, maxTime, avgTime, freq))
    {
      print(Stopwatch::getStopwatchEventIDName(Stopwatch::StopwatchEventID(i)), 0);
      char buf[30];
      sprintf(buf,"%.1f",minTime);
      print(buf, 1);
      sprintf(buf,"%.1f",maxTime);
      print(buf, 2);
      sprintf(buf,"%.1f",avgTime);
      print(buf, 3);
      sprintf(buf,"%.1f",freq);
      print(buf, 4);
      newLine();
    }
  }
  dc.SelectObject(oldFont);
}

void TimeView::print(const std::string& s, int column, bool bold)
{
  dc->SelectObject(bold ? &boldFont : &normalFont);
  if(!column)
    dc->TextOut((int)(5 + (width - 10) * leftOfColumnPercent[column]),
                line, s.c_str());
  else
    dc->TextOut((int)(5 + (width - 10) * leftOfColumnPercent[column] - dc->GetTextExtent(s.c_str()).cx),
                line, s.c_str());
}

void TimeView::newLine(bool drawLine)
{
  line += lineHeight;
  if(drawLine)
  {
    dc->MoveTo(0,line);
    dc->LineTo(width,line);
  }
}

/*
 * Change log :
 * 
 * $Log: TimeView.cpp,v $
 * Revision 1.1.1.1  2004/05/22 17:24:34  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.1  2004/04/09 18:55:16  roefer
 * Better structure for views
 * cp command added
 * Timing view added
 *
 */
