/** 
 * @file Platform/Win32/ForSimRobXP/PhysicalRobot.h
 *
 * Declaration of PhysicalRobot.
 *
 * @author <A href="mailto:roefer@tzi.de">Thomas Rfer</A>
 */

#ifndef __PhysicalRobot_H__
#define __PhysicalRobot_H__

#include "RobotConsole.h"
#include "Platform/Win32Linux/TcpConnection.h"

/**
 * @class PhysicalRobot
 *
 * A process that communicates with a physical robot.
 */
class PhysicalRobot : public RobotConsole, public TcpConnection, public Thread<PhysicalRobot>
{
  private:
    DEBUGGING;
    char name[80]; /**< The name of the robot. */
    char ip[80]; /**< The ip of the robot. */

    /**
     * The function connects to another process.
     */
    void connect();

    /**
     * The main loop of the process.
     */
    void run();

    /**
     * The function is called from the framework once in every frame.
     */
    virtual int main();
  
  public:
    /**
     * Constructor.
     * @param name The name of the robot.
     * @param ip The ip address of the robot.
     */
    PhysicalRobot(const char* name, const char* ip);

    /**
     * The function starts the process.
     */
    void start() {Thread<PhysicalRobot>::start(this,run);}

    /**
     * The function is called to announce the termination of the process.
     */
    void announceStop();
  
    /**
     * The function returns the name of the robot.
     * @return The name.
     */
    const char* getName() const {return name;}
};

#endif // __PhysicalRobot_H__


/*
 * Change log :
 *
 * $Log: PhysicalRobot.h,v $
 * Revision 1.1.1.1  2004/05/22 17:24:29  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.4  2004/04/14 14:47:57  roefer
 * Only wait one second if a robot cannot be connected
 *
 * Revision 1.3  2004/01/04 16:53:53  roefer
 * Adaptation to new communication scheme
 *
 * Revision 1.2  2003/10/16 15:30:34  goehring
 * Doxygen
 *
 * Revision 1.1  2003/10/14 07:34:16  roefer
 * Support files for SimRobXP added, not finished yet
 *
 */
