/** 
* @file Platform/Win32/ForSimRobXP/PhysicalRobot.cpp
*
* Implementation of PhysicalRobot.
*
* @author <A href="mailto:roefer@tzi.de">Thomas Rfer</A>
*/

#include "PhysicalRobot.h"
#include "Representations/Motion/HeadControlMode.h"
#include "Platform/GTAssert.h"
#include "Tools/Debugging/DebugDrawings.h"

PhysicalRobot::PhysicalRobot(const char* name, const char* ip)
: RobotConsole(theDebugReceiver,theDebugSender),
  theDebugReceiver(this,"Receiver.MessageQueue.O",false),
  theDebugSender(this,"Sender.MessageQueue.S",false)
{
  strcpy(this->name, name);
  strcpy(this->ip, ip);
  theDebugReceiver.setSize(1000000);
  theDebugSender.setSize(300000);
  dkt.set(DebugKeyTable::sendSpecialPercept,DebugKey::n_times,1);
  theDebugSender.out.bin << dkt;
  theDebugSender.out.finishMessage(idDebugKeyTable);
  // try to connect for one second
  Thread<PhysicalRobot>::start(this,connect);
  Thread<PhysicalRobot>::stop();
}

void PhysicalRobot::connect()
{
  TcpConnection::connect(ip,0xA1BD);
}

void PhysicalRobot::run()
{
  while(isRunning())
    Sleep(processMain());
}

int PhysicalRobot::main() 
{
  char* sendData,
      * receivedData;
  int sendSize = 0,
      receivedSize = 0;
  MessageQueue temp;

  {
    // If there is something to send, prepare a package
    if(!theDebugSender.isEmpty())
    {
      SYNC;
      OutBinarySize size;
      size << theDebugSender;
      sendSize = size.getSize();
      sendData = new char[sendSize];
      OutBinaryMemory stream(sendData);
      stream << theDebugSender;
      // make backup
      theDebugSender.moveAllMessages(temp);
    }
  }

  // exchange data with the router
  if(!sendAndReceive(sendData,sendSize,receivedData,receivedSize) && sendSize)
  { // sending failed, restore theDebugSender
    SYNC;
    // move all messages since cleared (if any)
    theDebugSender.moveAllMessages(temp);
    // restore
    temp.moveAllMessages(theDebugSender);
  }

  // If a package was prepared, remove it
  if(sendSize)
    delete [] sendData;

  // If a package was received from the router program, add it to receiver queue
  if(receivedSize > 0)
  {
    SYNC;
    InBinaryMemory stream(receivedData,receivedSize);
    stream >> theDebugReceiver;
    delete [] receivedData;
  }

  return 10;
}

void PhysicalRobot::announceStop()
{
  {
    SYNC;
    debugOut.out.bin << MotionRequest();
    debugOut.out.finishMessage(idMotionRequest);
    debugOut.out.bin << HeadControlMode();
    debugOut.out.finishMessage(idHeadControlMode);
    debugOut.out.bin << DebugKeyTable();
    debugOut.out.finishMessage(idDebugKeyTable);
  }
  Sleep(1000);
  Thread<PhysicalRobot>::announceStop();
}

/*
 * Change log :
 *
 * $Log: PhysicalRobot.cpp,v $
 * Revision 1.1.1.1  2004/05/22 17:24:29  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.6  2004/04/14 14:47:57  roefer
 * Only wait one second if a robot cannot be connected
 *
 * Revision 1.5  2004/03/11 00:08:45  roefer
 * Deadlock on connection loss removed
 *
 * Revision 1.4  2004/01/04 16:53:53  roefer
 * Adaptation to new communication scheme
 *
 * Revision 1.3  2003/10/25 11:52:20  roefer
 * Simulator is SimRobXP now
 *
 * Revision 1.2  2003/10/16 15:30:34  goehring
 * Doxygen
 *
 * Revision 1.1  2003/10/14 07:34:16  roefer
 * Support files for SimRobXP added, not finished yet
 *
 */
