/**
* @file Platform/Win32/File.cpp
* 
* Implementation of class File for Win32.
*/

#include "Platform/File.h"

#include <stdarg.h>
#include <string.h>
#include <direct.h>
#include "Platform/GTAssert.h"

File::File(const char* name,const char* mode)
{
  ASSERT(name);
  char buf[FILENAME_MAX];
  if(name[0] != '/' && name[0] != '\\' && name[0] != '.' && (name[0] == 0 || name[1] != ':'))
    sprintf(buf,"%s/Config/",getGTDir());
  else
    buf[0] = 0;
  ASSERT(strlen(buf) + strlen(name) < FILENAME_MAX);
  strcat(buf,name);
  stream = fopen(buf,mode);
}

File::~File() 
{
  if(stream != 0) fclose(stream);
}

void File::read(void* p,unsigned size) 
{
  VERIFY(!eof());fread(p,1,size,stream);
}

void File::write(const void *p,unsigned size) 
{
  //if opening failed, stream will be 0 and fwrite would crash
  ASSERT(stream!=0);
  VERIFY(fwrite(p,1,size,stream) == size);
}

void File::printf(const char* format, ...)
{
  va_list args;
  va_start(args,format);
  vfprintf(stream,format,args);
  va_end(args); 
}

bool File::eof()
{
	//never use feof(stream), because it informs you only after reading
	//to far and is never reset, e.g. if the stream grows afterwards
	//our implementation can handle both correctly:
  if(! stream)
    return false;
  else
  {
    int c = fgetc(stream);
    if(c==EOF)
      return true;
    else
    {
      VERIFY(ungetc(c,stream)!=EOF);
      return false;
    }
  }
}

char* File::getGTDir()
{
  static char dir[_MAX_PATH] = "";
  if(!dir[0])
  {
	  if(GetCommandLine()[0] == '"')
      strncpy(dir,GetCommandLine() + 1,strlen(GetCommandLine()) - 2);
    else
      strcpy(dir,GetCommandLine());
    if (strchr(dir,'\\')==NULL)
    {
      char path[_MAX_PATH];
      _getcwd(path,_MAX_PATH);
      strcat(path,"\\");
      strcat(path,dir);
      strcpy(dir,path);
    }
    //drive letter in lower case:
    if (dir[1]==':')
    {
      dir[0] |= 0x20;
    }
    int i = (int)strlen(dir) - 2;
    while(i >= 0)
    {
      while(i >= 0 && dir[i] != '\\')
        --i;
      if(i >= 0)
      {
        strcpy(&dir[i + 1],"Config");
        DWORD attr = GetFileAttributes(dir);
        if(attr != 0xffffffff && (attr & FILE_ATTRIBUTE_DIRECTORY))
        {
          dir[i] = 0;
          while(--i >= 0)
            if(dir[i] == '\\')
              dir[i] = '/';
          return dir;
        }
        else
          --i;
      }
    }
    strcpy(dir,"t:/GT2004");
  }
	return dir;
}

/*
* Change Log:
*
* $Log: File.cpp,v $
* Revision 1.1.1.1  2004/05/22 17:23:55  cvsadm
* created new repository GT2004_WM
*
* Revision 1.10  2004/05/19 08:06:00  dueffert
* assertion added
*
* Revision 1.9  2004/01/22 12:42:25  dueffert
* flush removed because it doesnt work properly on robots
*
* Revision 1.8  2004/01/16 15:46:27  dueffert
* flush added to File and OutFile
*
* Revision 1.7  2003/11/30 01:53:18  loetzsch
* prepared RobotControl port to Visual C++ .Net
*
* Revision 1.6  2003/10/25 11:52:20  roefer
* Simulator is SimRobXP now
*
* Revision 1.2  2003/10/12 19:01:13  roefer
* GT2003 -> GT2004
*
* Revision 1.1  2003/10/07 10:06:59  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.2  2003/09/30 13:20:12  dueffert
* path independence improved
*
* Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.9  2003/05/20 15:51:05  dueffert
* another case correction (used for path independent Depend)
*
* Revision 1.8  2003/05/19 09:32:14  dueffert
* case corrected
*
* Revision 1.7  2002/12/05 21:32:55  roefer
* getGTDir reimplemented
*
* Revision 1.6  2002/11/30 17:23:39  roefer
* SimGT2003 adaptations
*
* Revision 1.5  2002/11/28 14:03:37  dueffert
* getGTDir() implementation corrected
*
* Revision 1.4  2002/11/26 12:22:55  dueffert
* better implementation of File::eof() vor Windows
*
* Revision 1.3  2002/11/19 09:37:32  dueffert
* no message
*
* Revision 1.2  2002/11/18 17:32:35  dueffert
* RobotControl should be startable in any path now
*
* Revision 1.1  2002/09/10 15:40:04  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
* - Removed processing of incoming audio data
* - Renamed AcousticMessage to SoundRequest
*
* Revision 1.1  2002/07/23 13:38:22  loetzsch
* moved Implementation of File into an own C++ file
*
*/
