/**
* @file Platform/UDPHandler.h
*
* Inclusion of platform dependend process related classes and macros.
*
* @author <a href="mailto:robocup@m-wachter.de">Michael Wachter</a>
*/



#ifdef APERIOS1_3_2
#include "Aperios1.3.2/UDPHandler.h"

#define NET_RECEIVER(type) \
  NetReceiver<type> the##type##Receiver

#define INIT_NET_RECEIVER(type,blocking) \
  the##type##Receiver()

#define NET_SENDER(type) \
  NetSender<type> the##type##Sender

#define INIT_NET_SENDER(type,blocking) \
  the##type##Sender()

#define UDP_HANDLER \
  UDPHandler theUDPHandler

#define INIT_UDP_HANDLER(type) \
  theUDPHandler.addSenderAndReceiver(the##type##Sender, the##type##Receiver)

#define START_UDP_HANDLER \
  theUDPHandler.start();

#endif


#ifdef _WIN32

#define NET_RECEIVER(type) \
  Receiver<type> the##type##Receiver

#define INIT_NET_RECEIVER(type,blocking) \
  the##type##Receiver(this,"Receiver." #type ".O",blocking)

#define NET_SENDER(type) \
  Sender<type> the##type##Sender

#define INIT_NET_SENDER(type,blocking) \
  the##type##Sender(this,"Sender." #type ".S",blocking)

#define UDP_HANDLER
#define INIT_UDP_HANDLER(type)
#define START_UDP_HANDLER


#endif





/*
 * Change log :
 * 
 * $Log: UDPHandler.h,v $
 * Revision 1.1.1.1  2004/05/22 17:23:25  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.3  2004/05/14 14:12:08  wachter
 * - Added communication support for 5 robots
 * - rewrote parts of team-communication to be faster and more stable
 *
 * Revision 1.2  2004/01/09 15:44:30  wachter
 * Worked on with the Dog-Discovery-Protocol
 *
 * Revision 1.1  2003/12/21 19:27:02  wachter
 * Added classes for Sender/Receiver over TCP and UDP.
 * ( PLEASE DO NOT USE THIS NOW ! )
 * *
 */
