/**
* @file Platform/ProcessFramework.h
*
* Inclusion of platform dependend process related classes and macros.
*
* @author <a href="mailto:martin@martin-loetzsch.de">Martin Ltzsch</a>
*/

#ifdef APERIOS1_3_2
#include "Aperios1.3.2/ProcessFramework.h"
#define PROCESSFRAMEWORK_INCLUDED
#endif

#ifdef _WIN32
#include "Win32/ProcessFramework.h"
#define PROCESSFRAMEWORK_INCLUDED
#endif

#ifdef LINUX
#include "Linux/ProcessFramework.h"
#define PROCESSFRAMEWORK_INCLUDED
#endif

#ifdef CYGWIN
#include "Linux/ProcessFramework.h"
#define PROCESSFRAMEWORK_INCLUDED
#endif

#ifndef PROCESSFRAMEWORK_INCLUDED
#error Unknown platform
#endif

/*
 * Change log :
 * 
 * $Log: ProcessFramework.h,v $
 * Revision 1.1.1.1  2004/05/22 17:23:25  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.1  2003/10/07 10:06:58  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.2  2003/05/05 11:56:56  dueffert
 * now using ifdef instead of if
 *
 * Revision 1.1  2002/09/10 15:40:04  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.1.1.1  2002/05/10 12:40:18  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.8  2002/05/02 17:04:08  roefer
 * New router
 *
 * Revision 1.7  2002/04/20 15:52:19  roefer
 * Project simpified, WATCH and WATCH_PART added
 *
 * Revision 1.6  2002/01/14 22:45:00  loetzsch
 * SimRobot / RobotControl integration started
 *
 * Revision 1.5  2001/12/10 17:47:08  risler
 * change log added
 *
 */
