#include "ProcessFramework.h"

void ProcessBase::nextFrame()
{
  theInstance->processNextFrame();
}

void ProcessBase::setBlockingId(int id,bool block)
{
  if(block)
    blockMask |= 1 << id;
  else
    blockMask &= ~(1 << id);
}

void ProcessBase::setEventId(int id)
{
  eventMask |= 1 << id;
  if(blockMask && (eventMask & blockMask) == blockMask)
  {
    blockMask = 0;
    nextFrame();
  }
}

/*
 * Change log :
 * 
 * $Log: ProcessFramework.cpp,v $
 * Revision 1.1.1.1  2004/05/22 17:23:41  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.1  2003/10/07 10:06:59  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.1  2002/09/10 15:40:04  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.1.1.1  2002/05/10 12:40:18  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.1  2002/05/02 17:04:08  roefer
 * New router
 *
 * Revision 1.8  2002/04/21 21:03:07  roefer
 * Again, events block with &-logic
 *
 * Revision 1.7  2002/04/20 15:52:20  roefer
 * Project simpified, WATCH and WATCH_PART added
 *
 * Revision 1.6  2001/12/15 20:32:08  roefer
 * Senders and receivers are now part of the processes
 *
 * Revision 1.5  2001/12/12 13:25:02  roefer
 * Blocking sender fixed
 *
 * Revision 1.4  2001/12/10 17:47:08  risler
 * change log added
 *
 */
