/**
* @file Platform/File.h
*
* Inclusion of platform dependend definitions of simple file handling. 
*
* @author <a href="mailto:roefer@tzi.de">Thomas Rfer</a>
*/

#ifdef APERIOS1_3_2
#include "Aperios1.3.2/File.h"
#define FILE_INCLUDED
#endif

#ifdef _WIN32
#include "Win32/File.h"
#define FILE_INCLUDED
#endif

#ifdef LINUX
#include "Linux/File.h"
#define FILE_INCLUDED
#endif

#ifdef CYGWIN
#include "Linux/File.h"
#define FILE_INCLUDED
#endif

#ifndef FILE_INCLUDED
#error Unknown platform
#endif

/*
 * Change log :
 * 
 * $Log: File.h,v $
 * Revision 1.1.1.1  2004/05/22 17:23:21  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.1  2003/10/07 10:06:58  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.2  2003/05/05 11:56:29  dueffert
 * now using ifdef instead of if
 *
 * Revision 1.1  2002/09/10 15:40:04  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.3  2002/07/06 20:08:09  roefer
 * Advances towards gcc
 *
 * Revision 1.2  2002/07/04 16:23:33  dueffert
 * started to port to gcc
 *
 * Revision 1.1.1.1  2002/05/10 12:40:18  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.6  2002/05/02 17:04:08  roefer
 * New router
 *
 * Revision 1.5  2002/01/14 22:45:00  loetzsch
 * SimRobot / RobotControl integration started
 *
 * Revision 1.4  2001/12/10 17:47:08  risler
 * change log added
 *
 */
