/** 
* @file  Platform/Aperios1.3.2/UDPHandler.cpp
*
* Class for using NetSender/NetReceivers over UDP 
* @author <A href=mailto:robocup@m-wachter.de>Michael Wachter</A>
* 
*/

#include "UDPHandler.h"
#include <tools/debugging/debugging.h>

#include <stdio.h>
#include <iostream.h>

UDPHandlerEndpoint::UDPHandlerEndpoint() : UDPEndpoint(2048,2048)
{
     	lastReceivedSerial=0;
		sendSerial=0;
}

UDPHandlerEndpoint::~UDPHandlerEndpoint()
{

};

void UDPHandlerEndpoint::sendPackage(int senderNumber, void* packet, int size)
{
  // cout << "Sender " << senderNumber << " wants to send :" ;
  
  if ((ddpHandler->list[sender->senderNumber].ip != IP_ADDR_ANY) && 
    (SystemCall::getTimeSince(ddpHandler->list[sender->senderNumber].timeLastSeen) < 10000) &&
    (size<1400))
  {
    // cout << " sending to " << ddpHandler.list[senderNumber].ip << " \n " << flush;
      char* ende = static_cast<char*>(packet);
      
      ende += size;
      sendSerial++;
      memcpy(ende,&sendSerial,4);
	  send((char*)(packet),size+4,ddpHandler->list[sender->senderNumber].ip,
		   TEAMPORTBASE + (int)getPlayer().getPlayerNumber());
      
  }
  else
  {
     // cout << " no target ";
      sender->sendDone();
  }
  udpHandler->doRegularStuff();
  // cout << "\n" << flush;
}

void UDPHandlerEndpoint::onSendingDone()
 {
	 sender->sendDone();
 }

void UDPHandlerEndpoint::onReceive(void *data, int size)
{

   /*  cout << "UDPHandlerEndpoint::onReceive() ";
	 cout << size << " " << sender->senderNumber << " ";   // 13
	 char pN = ((char*)data)[17] ;
	 cout << ((int)pN) << " ";
	 cout << "listip: " << ddpHandler->list[sender->senderNumber].ip << " ip: " << ipOfLastPackage ;
	 cout << "\n"; */

    
    
     if (ddpHandler->list[sender->senderNumber].ip == ipOfLastPackage)
     {
        // cout << " handler " << i ;
        int packetSize = *(int*)data;

		// Scheiss alignment-kack !!!
        char* ende = static_cast<char*>(data);
        ende += packetSize;
        ende += 4;
        int serial;
        memcpy(&serial,ende,4);

        if (serial != lastReceivedSerial + 1)
        {
             OUTPUT(idText,text,
               "Packet-Loss from " << ipOfLastPackage << " detected.(Serial:"
               << serial << " last package:" << lastReceivedSerial 
               << ")" << serial-lastReceivedSerial+1 << " Packets missing");
        }

        lastReceivedSerial = serial;

        receiver->getPackage(packetSize);
        memcpy(receiver->package, (char*)data + 4, packetSize);
        receiver->onReceive();
     }
	 else
	 {
         cout << "ip <-> DDP-ip mismatch \n";
	 }
  
}


UDPHandler::UDPHandler()
{
   numberOfEndpoints = 0;
}

void UDPHandler::addSenderAndReceiver(NetSenderBase& sender, NetReceiverBase& receiver)
{
    endPoints[numberOfEndpoints].sender = &sender;
	endPoints[numberOfEndpoints].receiver = &receiver;
	endPoints[numberOfEndpoints].sender->setHandler(&endPoints[numberOfEndpoints]);
    endPoints[numberOfEndpoints].sender->getPackage(2048);
	endPoints[numberOfEndpoints].sender->senderNumber = numberOfEndpoints;
    endPoints[numberOfEndpoints].receiver->getPackage(2048);
	endPoints[numberOfEndpoints].ddpHandler = &ddpHandler;
	endPoints[numberOfEndpoints].udpHandler = this;
	numberOfEndpoints++;

}
void UDPHandler::start()
{
    ddpHandler.initDDPHandler();
	int i;
	int j = 0;
	for (i=0; i< Player::numOfPlayerNumbers; i++)
    {
      if ((int)getPlayer().getPlayerNumber() != i)
	  {
           endPoints[j].bind(TEAMPORTBASE+i);   
           j++;
	  }
    }
}

void UDPHandler::doRegularStuff()
{
    ddpHandler.sendDDPPackage();
}







  // cout << "\n";




/*
 * Change log :
 * 
 * $Log: UDPHandler.cpp,v $
 * Revision 1.1.1.1  2004/05/22 17:23:41  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.8  2004/05/14 14:12:08  wachter
 * - Added communication support for 5 robots
 * - rewrote parts of team-communication to be faster and more stable
 *
 * Revision 1.7  2004/05/14 12:20:28  tim
 * fixed typo
 *
 * Revision 1.6  2004/01/26 13:44:07  wachter
 * shared-memory-buffers now have variable sizes
 *
 * Revision 1.5  2004/01/23 18:28:47  wachter
 * Added detection of lost packets
 *
 * Revision 1.4  2004/01/21 17:33:09  wachter
 * UDP Team-communication now working with packets<1400 bytes.
 * Not activated at the moment.
 *
 * Revision 1.3  2004/01/20 14:21:41  wachter
 * - Added sender-number to NetSender
 * - worked on with Team-Communication
 *
 * Revision 1.2  2004/01/09 15:44:30  wachter
 * Worked on with the Dog-Discovery-Protocol
 *
 * Revision 1.1  2003/12/21 19:27:03  wachter
 * Added classes for Sender/Receiver over TCP and UDP.
 * ( PLEASE DO NOT USE THIS NOW ! )
 *
 * 
 */

