/** 
* @file  Platform/Aperios1.3.2/UDPEndpoint.cpp
*
* Implementation for IP Communication Classes
* @attention this is the Aperios implementation
*
* @author <A href=mailto:robocup@m-wachter.de>Michael Wachter</A>
* 
*/

#include "UDPEndpoint.h"
#include <stdio.h>
#include <iostream.h>


UDPEndpoint::UDPEndpoint(int sendBufferSize, int receiveBufferSize)
:IPEndpoint(sendBufferSize,receiveBufferSize)
{
   cout << "UDPEndpoint: Creating Endpoint \n";

   antEnvCreateEndpointMsg udpCreateMsg( EndpointType_UDP, sharedSendBufferSize+2048);
   udpCreateMsg.Call(ipStackRef, sizeof(udpCreateMsg));

   if (udpCreateMsg.error != ANT_SUCCESS) 
   {
     cout << "UDPEndpoint: Can't create Endpoint, error " << udpCreateMsg.error << "\n";
     return;
   }
   endpoint = udpCreateMsg.moduleRef;
}


UDPEndpoint::~UDPEndpoint()
{
  // 
  close();
}

int UDPEndpoint::bind(int port)
{
  cout << "UDPEndpoint: bind to port " << port << "\n";
  listenPort = port;
  UDPEndpointBindMsg bindMsg(endpoint, IP_ADDR_ANY, listenPort);
  bindMsg.Call(ipStackRef, sizeof(bindMsg));
  
  if(bindMsg.error != 0)
  {
      cout << "UDPEndpoint::bind() Error binding " << 
        getErrorString(bindMsg.error) << "\n";
  }

  startReceiving();
  return(0);
}

int UDPEndpoint::bind(Port lPort, IPAddress addr, Port sPort)
{
  cout << "UDPEndpoint: set sending-addr to " << addr << ":" << sPort << "\n";
  sendPort = sPort;
  address = addr;
  bind(lPort);
  return(0);
}

int UDPEndpoint::bind(int lPort, char* addr, int sPort)
{
  cout << "UDPEndpoint: set sending-addr to " << addr << ":" << sPort << "\n";
  sendPort = sPort,
  address = addr;
  bind(lPort);
  return(0);
}

int UDPEndpoint::send(void* data,int size)
{
  // Copy data to shared buffer
  memcpy(sharedSendBuffer,data,size);
  send(size);
  return(0);
}

int UDPEndpoint::send(int size)
{
  UDPEndpointSendMsg sendMsg(endpoint,address,sendPort,sharedSendBuffer,size);
  sendMsg.continuation = this;
  sendMsg.Send(ipStackRef, *myOID_, *sendContSelector, sizeof(sendMsg));
  return(0);
}

int UDPEndpoint::send(int size, char* addr, int sPort)
{
   address = addr;
   sendPort = sPort;
   send(size);
   return(0);
}


int UDPEndpoint::send(void* data, int size, char* addr,int sPort)
{
  address = addr;
  sendPort = sPort;
  send(data, size);
  return(0);
}

int UDPEndpoint::send(void* data, int size, IPAddress addr,int sPort)
{
  address = addr;
  sendPort = sPort;
  send(data, size);
  return(0);
}

void UDPEndpoint::sendCont(antEnvMsg* msg)
{
    // cout << "UDPEndpoint::SendCont \n";
    UDPEndpointSendMsg* sendMsg = (UDPEndpointSendMsg*) msg;

    if (sendMsg->error != UDP_SUCCESS)
    {
      cout << "UDPEndpoint::SendCont Error : " << 
        getErrorString(sendMsg->error) << "\n";
      return;
    }
    onSendingDone();
   
}

void UDPEndpoint::onSendingDone()
{
}

void UDPEndpoint::onReceive(void* data,int size)
{
  // cout << "UDPEndpoint::receive Size= " << size << "\n";
  return;
}

void UDPEndpoint::startReceiving()
{ 
    // cout << "UDPEndpoint::startReceiving()\n";
    
    UDPEndpointReceiveMsg receiveMsg(endpoint,sharedReceiveBuffer,sharedReceiveBufferSize);
    receiveMsg.continuation = this;
    receiveMsg.Send(ipStackRef, *myOID_, *receiveContSelector, sizeof(receiveMsg));
}

void UDPEndpoint::receiveCont(antEnvMsg* msg)
{
    // cout << "UDPEndpoint::receiveCont \n";
    UDPEndpointReceiveMsg* receiveMsg = (UDPEndpointReceiveMsg*) msg;
    if (receiveMsg->error != UDP_SUCCESS)
    {
       cout << "UDPEndpoint: Error receiving " << 
         getErrorString(receiveMsg->error) << "\n";
       return;
    }
    ipOfLastPackage = receiveMsg->address;
    onReceive(sharedReceiveBuffer,receiveMsg->size);
    startReceiving();
}
       
void UDPEndpoint::close()
{
    // cout << "UDPEndpoint::close() \n";
    onClose();
    UDPEndpointCloseMsg closeMsg(endpoint);
    closeMsg.continuation = this;
    closeMsg.Send( ipStackRef, *myOID_, *closeContSelector, sizeof(closeMsg));
}

void UDPEndpoint::onClose()
{
}

void UDPEndpoint::closeCont(antEnvMsg* msg)
{
   // cout << "UDPEndpoint::CloseCont \n";
   //UDPEndpointCloseMsg closeMsg = (UDPEndpointCloseMsg*) msg;
   return;
}
 
const char* UDPEndpoint::getErrorString(UDPEndpointError error)
{
   switch (error)
    {
    case UDP_ADDRESSERROR: return "UDP_ADDRESSERROR (IP/Port unvalid)";
    case UDP_ADDRESSINUSE: return "UDP_ADDRESSINUSE (IP/Port in used by another endpoint)";
    case UDP_BUFFER_INVALID: return "UDP_BUFFER_INVALID (Address not in shared memory)";
    case UDP_CONNECTION_BUSY: return "UDP_CONNECTION_BUSY (Endpoint does something else)";
    case UDP_CONNECTION_CLOSED: return "UDP_CONNECTION_CLOSED (Endpoint not open)";
    case UDP_FAIL: return "UDP_FAIL (no more information is avialble)";
    case UDP_HOST_UNREACHABLE: return "UDP_HOST_UNREACHABLE";
    case UDP_MESSAGE_TOO_LONG: return "UDP_MESSAGE_TOO_LONG (Paket too long for an intermediate router)";
    case UDP_NETWORK_UNREACHABLE: return "UDP_NETWORK_UNREACHABLE";
    case UDP_OPERATION_INVALID: return "UDP_OPERATION_INVALID (Operation not allowed in current state of endpoint)";
    case UDP_OPERATION_UNKNOWN: return "UDP_OPERATION_UNKNOWN";
    case UDP_PORT_UNREACHABLE: return "UDP_PORT_UNREACHABLE";
    case UDP_PROTOCOL_UNREACHABLE: return "UDP_PROTOCOL_UNREACHABLE (Target host does not run UDP)";
    case UDP_SUCCESS: return "UDP_SUCCESS";
    case UDP_TIME_EXCEEDED: return "UDP_TIME_EXCEEDED";
    case UDP_TTL_EXCEEDED: return "UDP_TTL_EXCEEDED";
          
    default: return "UCP_UNKNOWN_ERROR please edit UCPEndpoint::getErrorSring";
    }
}


/*
 * Change log :
 * 
 * $Log: UDPEndpoint.cpp,v $
 * Revision 1.1.1.1  2004/05/22 17:23:41  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.6  2004/01/26 13:44:07  wachter
 * shared-memory-buffers now have variable sizes
 *
 * Revision 1.5  2004/01/21 17:33:09  wachter
 * UDP Team-communication now working with packets<1400 bytes.
 * Not activated at the moment.
 *
 * Revision 1.4  2004/01/20 14:21:41  wachter
 * - Added sender-number to NetSender
 * - worked on with Team-Communication
 *
 * Revision 1.3  2004/01/09 15:44:30  wachter
 * Worked on with the Dog-Discovery-Protocol
 *
 * Revision 1.2  2003/12/11 15:02:37  wachter
 * Low-level TCP and UDP functions for aperios now working.
 *
 * Revision 1.1  2003/12/03 14:21:52  wachter
 * Splitted IPEndpoint.*
 *
 *
 */

