/** 
* @file  Platform/Aperios1.3.2/TCPHandler.cpp
*
* Class for using NetSender/NetReceivers over a TCP connection
*
* @author <A href=mailto:robocup@m-wachter.de>Michael Wachter</A>
* 
*/

#include "TCPHandler.h"

#include <stdio.h>
#include <iostream.h>
#include <iomanip.h>

/*
  * The associated sender first finds out the size of the data to send
  * and streams the data into a memory buffer. After that the sender calls
  * sendPackage in the TCPHandler and the TCPHandler takes care of sending
  * the data to the other host.
  *
  * the TCPHandler first sends the size of the data and after that the data
  * itself.
  *
  * If there is incomining data the TCPHandler first reads the size of the
  * incoming Data and after that all received data is collected in a memory
  * buffer until it is complete. Now the associated receiver is called to
  * stream the data from the buffer.
*/

TCPHandler::TCPHandler(NetSenderBase &theSender, NetReceiverBase &theReceiver)
:TCPEndpoint(16384,16384)
{
   sender = &theSender;
   receiver = &theReceiver;
   sender->setHandler(this);
   sizeOfDataToRead = 0;
   sendingDone = true;
  
   sender->getPackage(131072*2);
   receiver->getPackage(8192);
 
}

void TCPHandler::setTransmitters(NetSenderBase& theSender, NetReceiverBase& theReceiver)
{
  sender = &theSender;
  receiver = &theReceiver;
  sender->setHandler(this);
}

void TCPHandler::onReceive(void* someData, int size)
{
   // "size" is always the number of bytes left to read
   
   // cout << "TCPHandler::onReceive(" << someData <<","<<size<<") \n";

   // if(sendingDone) sender->sendDone();


   while(size > 0)  
   {
     
  //   cout << "Bytes left: " << size << " SomeData " << someData << " \n" << flush;
     
     if (sizeOfDataToRead == 0)           
     {
       // Get size of Data
       // cout << "   - Stream start \n " ;
       memcpy(&sizeOfDataToRead,someData,sizeof(int));

       // Todo : Unwahrscheinlichen Fall das die Size auf 2 Packete verteilt
       // ankommt abfangen
       ASSERT(size>3);

       // cout << "    Size = " << sizeOfDataToRead << "\n" ;
       (char*)someData+=sizeof(int);
       size-=sizeof(int);                  

       // Get the buffer to store the data into
       if (sizeOfDataToRead > 0)
       { 
          receiveBuffer=receiver->getPackage(sizeOfDataToRead);
       }
      /* Heartbeat or other data received received  */
	   /*if(sendingDone) sender->sendDone(); */
     }
     else 
     {
        // Get Data
        if (sizeOfDataToRead > 0 && size != 0)
        {
          int bytesToRead = sizeOfDataToRead;        
          if (bytesToRead > size) bytesToRead = size;   

           // cout << "   - need " << sizeOfDataToRead << " more bytes " 
           //     << "- Getting " << bytesToRead << " bytes \n" << flush; 

          memcpy(receiveBuffer,someData,bytesToRead); 
      
          sizeOfDataToRead -= bytesToRead;
          (char*)receiveBuffer += bytesToRead; // Position to copy next package
      
          size -= bytesToRead;
          (char*)someData += bytesToRead;       // Position to read next data

        }
              // All Data copied ?
        if (sizeOfDataToRead == 0)
        {
           // cout << "   - All Data collected : Streaming - \n";
           receiver->onReceive();
        }
     }
  }
}

void TCPHandler::onConnect(void)
{
  cout << "TCPHandler::Connection established \n" << flush;
  sizeOfDataToRead = 0;
  sendingDone = true;
  sender->sendDone();
}

void TCPHandler::onClose(int reason)
{
    cout << "TCPHandler::Connection closed \n" << flush;
 
}

void TCPHandler::onSendingDone(void)
{
   sendingDone=true;
   sender->sendDone();
}

void TCPHandler::sendPackage(int senderNumber, void* someData,int size)
{
  // cout << "TCPHandler::sendPackage : size " << size << "\n" << flush;
  sendingDone=false;
  if(status==connected) 
  {
    send(someData,size);  // Calls send from TCPEndpoint
  }
}


/*
 * Change log :
 * 
 * $Log: TCPHandler.cpp,v $
 * Revision 1.2  2004/05/25 14:39:35  wachter
 * Debug-communication does not need special handshaking any more
 *
 * Revision 1.1.1.1  2004/05/22 17:23:40  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.7  2004/01/26 13:44:07  wachter
 * shared-memory-buffers now have variable sizes
 *
 * Revision 1.6  2004/01/20 14:21:41  wachter
 * - Added sender-number to NetSender
 * - worked on with Team-Communication
 *
 * Revision 1.5  2004/01/20 13:45:36  wachter
 * Changed sizes of MessageQueue and memory-allocation
 *
 * Revision 1.4  2004/01/16 16:23:58  wachter
 * Bugfixes
 *
 * Revision 1.3  2004/01/03 18:57:50  wachter
 * Debug-communication working now
 *
 * Revision 1.2  2004/01/03 16:18:25  wachter
 * debug-communication mostly working now
 *
 * Revision 1.1  2003/12/21 19:27:03  wachter
 * Added classes for Sender/Receiver over TCP and UDP.
 * ( PLEASE DO NOT USE THIS NOW ! )
 *
 * 
 */

