/**
 * @file Platform/Aperios1.3.2/Receiver.cpp
 * This file implements classes related to receivers for Aperios.
 */
#include "ProcessFramework.h"

ReceiverList::ReceiverList(PlatformProcess* p,const char* receiverName,bool blocking)
{
  process = p;
  // copy the receiver's name. The name of the process is still missing.
  strcpy(this->name,receiverName);
  if(getFirst())
  {
    ReceiverList* p = getFirst();
    while(p->next)
      p = p->next;
    p->next = this;
  }
  else
    getFirst() = this;
  next = 0;
  this->blocking = blocking;
}

ReceiverList*& ReceiverList::getFirst()
{
  return process->getFirstReceiver();
}

bool ReceiverList::receivedNew() const
{
  return (ProcessBase::getEventMask() & 1 << eventId) != 0;
}

void ReceiverList::finishFrame()
{
  for(ReceiverList* p = getFirst(); p; p = p->getNext())
  {
    ProcessBase::setBlockingId(p->eventId,p->blocking);
    if(p->receivedNew())
      p->AssertReady();
  }
}

void ReceiverList::setBlockingId(int id,bool block)
{
  ProcessBase::setBlockingId(id,block);
}

void ReceiverList::setEventId(int id)
{
  ProcessBase::setEventId(id);
}

/*
 * Change log :
 * 
 * $Log: Receiver.cpp,v $
 * Revision 1.1.1.1  2004/05/22 17:23:28  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.1  2003/10/07 10:06:59  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.2  2002/12/02 11:00:13  dueffert
 * doxygen docu corrected
 *
 * Revision 1.1  2002/09/10 15:40:04  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.2  2002/07/06 15:28:28  roefer
 * Prologue function removed
 *
 * Revision 1.1.1.1  2002/05/10 12:40:18  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.4  2001/12/15 20:32:08  roefer
 * Senders and receivers are now part of the processes
 *
 * Revision 1.3  2001/12/12 14:06:17  roefer
 * Fixed blocking sender
 *
 * Revision 1.2  2001/12/10 17:47:08  risler
 * change log added
 *
 */
