/**
 * @file Platform/Aperios1.3.2/GTAssert.h
 *
 * This file contains macros for low level debugging.
 *
 * @author Thomas Rfer
 */

#ifndef __GTAssert_h_
#define __GTAssert_h_

#include <stdio.h>

#ifdef min
#undef min
#endif
#ifdef max
#undef max
#endif
#include <iostream.h>

#ifdef NDEBUG
#define ASSERT(cond) ((void)0)
#define VERIFY(cond) ((void)(cond))
#define PRINT(text) ((void)0)

#else

/**
 * ASSERT prints a message if cond is false and NDEBUG is not defined.
 * ASSERT does not evaluate cond if NDEBUG is defined.
 * Note that printf will not work in early stages of the creation of an Aperios
 * process. Therefore, you will not get any feedback in such a case. If you are
 * not sure whether an assertion failure will be reported at a certain position
 * in the code, try ASSERT(false).
 * @param cond The condition to be checked.
 */
#define ASSERT(cond) {if(!(cond)) ::printf("ASSERT(" #cond ") failed in line %d of file " \
  __FILE__ ".\n",__LINE__);}

/**
 * VERIFY prints a message if cond is false and NDEBUG is not defined.
 * VERIFY does evaluate cond even if NDEBUG is defined.
 * Note that printf will not work in early stages of the creation of an Aperios
 * process. Therefore, you will not get any feedback in such a case. If you are
 * not sure whether an assertion failure will be reported at a certain position
 * in the code, try ASSERT(false).
 * @param cond The condition to be checked.
 */
#define VERIFY(cond) {if(!(cond)) ::printf("VERIFY(" #cond ") failed in line %d of file " \
  __FILE__ ".\n",__LINE__);}

/**
 * PRINT prints a text directly to the output if and NDEBUG is not defined.
 * PRINT does not evaluate the parameter if NDEBUG is defined.
 * @param text The text that will be printed.
 */
#define PRINT(text) {cout << text << "\n"; cout.flush();}

#endif

#endif // __GTAssert_h_

/*
 * Change log :
 * 
 * $Log: GTAssert.h,v $
 * Revision 1.3  2004/05/29 13:20:16  dueffert
 * GTAssert inclusion problem (min() macro vs. std::min()) really  fixed now
 *
 * Revision 1.2  2004/05/28 18:26:36  dueffert
 * GTAssert is allowed in headers again
 *
 * Revision 1.1.1.1  2004/05/22 17:23:25  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.1  2003/10/07 10:06:59  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.5  2003/05/06 22:19:11  dueffert
 * Greenhills compilability restored
 *
 * Revision 1.4  2003/03/30 11:57:27  loetzsch
 * removed backward warnings
 *
 * Revision 1.3  2003/02/17 10:41:00  dueffert
 * greenhills backport
 *
 * Revision 1.2  2003/02/10 13:59:26  dueffert
 * gcc32 adaption
 *
 * Revision 1.1  2002/09/10 15:40:04  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.1  2002/07/23 13:35:49  loetzsch
 * - renamed Debugging.h to GTAssert.h
 * - removed #include "Oracle.h" in Win32 version
 *
 * Revision 1.1.1.1  2002/05/10 12:40:18  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.5  2001/12/30 14:48:37  roefer
 * Portable macro PRINT() for direct console output inserted
 *
 * Revision 1.4  2001/12/10 17:47:08  risler
 * change log added
 *
 */
