/**
* @file Platform/Aperios1.3.2/File.h
* 
* Declaration of class File for Aperios 1.3.2.
*/

#ifndef __File_h__
#define __File_h__

#ifdef __GNUC__
#include <stdio.h>
#define OFS
#else
#include <FileSystem/futil.h>
#endif

/**
* This class provides basic file input/output capabilies. 
*/
class File
{
private:
  OFS::FILE* stream; /**< File handle. */
  char buf[65536]; /**< A buffer to reduce the number of operation system calls. */
  unsigned int bufSize, /**< The number of bytes in the buffer while reading. */
    index; /**< The next byte in the buffer to read/write. */
  bool isWrite; /**< Is this a write stream? */
public:
/**
* Constructor.
* @param name File name or path. If it is a relative path, it is assumed
*             to be relative to the path for configuration files. Otherwise,
*             the path is used directly.
* @param mode File open mode as used by fopen defined in stdio.h.
  */
  File(const char* name,const char* mode);
  
  /**
  * Destructor.
  */
  ~File();
  
  /**
  * The function read a number of bytes from the file to a certain
  * memory location.
  * @param p The start of the memory space the data is written to.
  * @param size The number of bytes read from the file.
  */
  void read(void* p,unsigned size);
  
  /**
  * The function writes a number of bytes from a certain memory 
  * location into the file.
  * @param p The start of the memory space the data is read from.
  * @param size The number of bytes written into the file.
  */
  void write(const void *p,unsigned size); 
  
  /**
  * The function implements printf for the stream represented by
  * instances of this class.
  * @param format Format string as used by printf defined in stdio.h.
  * @param ... See printf in stdio.h.
  */
  void printf(const char* format, ...);
  
  /**
  * The function returns whether the file represented by an
  * object of this class actually exists.
  * @return The existence of the file.
  */
  bool exists() const {return stream != 0;}
  
  /**
  * The function returns whether the end of the file represented 
  * by an object of this class was reached.
  * @return End of file reached?
  */
  bool eof() const; 

  /**
  * The function returns the current GT directory,
  * e.g. /MS/OPENR/APP or <...>/GT2003 or /usr/local/GT2003
  * @return The current GTDir
  */
  static char* getGTDir(); 
};

#endif // __FILE_H__

/*
* Change log :
* 
* $Log: File.h,v $
* Revision 1.1.1.1  2004/05/22 17:23:25  cvsadm
* created new repository GT2004_WM
*
* Revision 1.3  2004/01/22 12:42:25  dueffert
* flush removed because it doesnt work properly on robots
*
* Revision 1.2  2004/01/16 15:46:27  dueffert
* flush added to File and OutFile
*
* Revision 1.1  2003/10/07 10:06:59  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.2  2003/09/26 11:36:26  juengel
* - sorted tools
* - clean-up in DataTypes
*
* Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.3  2003/03/11 09:02:12  dueffert
* signed comparison warning removed
*
* Revision 1.2  2002/11/18 17:32:35  dueffert
* RobotControl should be startable in any path now
*
* Revision 1.1  2002/09/10 15:40:04  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
* - Removed processing of incoming audio data
* - Renamed AcousticMessage to SoundRequest
*
* Revision 1.6  2002/07/23 13:38:22  loetzsch
* moved Implementation of File into an own C++ file
*
* Revision 1.5  2002/07/14 14:03:07  roefer
* First working gcc-version
*
* Revision 1.4  2002/07/09 15:24:53  dueffert
* not nice but working
*
* Revision 1.3  2002/07/08 11:53:33  dueffert
* further steps towards gcc
*
* Revision 1.2  2002/07/06 20:08:09  roefer
* Advances towards gcc
*
* Revision 1.1.1.1  2002/05/10 12:40:18  cvsadm
* Moved GT2002 Project from ute to tamara.
*
* Revision 1.10  2002/04/23 15:44:47  roefer
* Comments added
*
* Revision 1.9  2002/04/23 15:19:42  roefer
* Buffered file i/o
*
* Revision 1.8  2001/12/22 08:25:30  roefer
* Enhanced constructor of class File, removed second one
*
* Revision 1.7  2001/12/13 13:12:27  risler
* added #include <string.h>
*
* Revision 1.6  2001/12/12 15:19:52  juengel
* if(stream != 0) im Destruktor vor fclose(stream); ergnzt.
*
* Revision 1.5  2001/12/10 17:47:08  risler
* change log added
*
*/
