/** 
* @file  Platform/Aperios1.3.2/DDPHandler.h
*
* Handles the Dog Discovery Protocol (DDP) so that the robot
* is able to find out the ip's of his teammates.
*
* @author <A href=mailto:robocup@m-wachter.de>Michael Wachter</A>
*/

#ifndef	_DDPHandler_H_
#define	_DDPHandler_H_

#include "UDPEndpoint.h"
#include "Tools/Player.h"

class DDPListEntry
{
  public:
    IPAddress ip;
    Port port;
    unsigned long timeLastSeen;
};

class DDPPackage
{
   public:
      char teamIdentifier[16];
      Player::teamColor teamColor;
      Player::playerNumber playerNumber;
};     

class DDPHandler : public UDPEndpoint
{
  public:
    DDPHandler();
    ~DDPHandler() {} ;
    void initDDPHandler();
   
    void updateDDPList();  /* ka ob ich das wirklich brauch */
    IPAddress getIPAddress(int number);

    void sendDDPPackage();

    virtual void onReceive(void* data, int size);

  public:
	  DDPListEntry list[Player::numOfPlayerNumbers-1];
      char teamIdentifier[16];
    
  private:
    DDPPackage thePackage;
    unsigned long timeLastPackage;

};


#endif 

/*
 *
 * Changelog :
 *
 * $Log: DDPHandler.h,v $
 * Revision 1.1.1.1  2004/05/22 17:23:25  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.3  2004/05/14 14:12:08  wachter
 * - Added communication support for 5 robots
 * - rewrote parts of team-communication to be faster and more stable
 *
 * Revision 1.2  2004/01/09 15:44:30  wachter
 * Worked on with the Dog-Discovery-Protocol
 *
 * Revision 1.1  2003/12/21 19:27:02  wachter
 * Added classes for Sender/Receiver over TCP and UDP.
 * ( PLEASE DO NOT USE THIS NOW ! )
 *
 *
 */
